/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.time.Instant;
import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.PathMarshallers;
import software.amazon.awssdk.services.s3.model.CopyObjectRequest;
import software.amazon.awssdk.util.StringUtils;

public class CopyObjectRequestMarshaller
implements Marshaller<Request<CopyObjectRequest>, CopyObjectRequest> {
    public Request<CopyObjectRequest> marshall(CopyObjectRequest copyObjectRequest) {
        if (copyObjectRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)copyObjectRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.PUT);
        if (copyObjectRequest.acl() != null) {
            request.addHeader("x-amz-acl", StringUtils.fromString((String)copyObjectRequest.acl()));
        }
        if (copyObjectRequest.cacheControl() != null) {
            request.addHeader("Cache-Control", StringUtils.fromString((String)copyObjectRequest.cacheControl()));
        }
        if (copyObjectRequest.contentDisposition() != null) {
            request.addHeader("Content-Disposition", StringUtils.fromString((String)copyObjectRequest.contentDisposition()));
        }
        if (copyObjectRequest.contentEncoding() != null) {
            request.addHeader("Content-Encoding", StringUtils.fromString((String)copyObjectRequest.contentEncoding()));
        }
        if (copyObjectRequest.contentLanguage() != null) {
            request.addHeader("Content-Language", StringUtils.fromString((String)copyObjectRequest.contentLanguage()));
        }
        if (copyObjectRequest.contentType() != null) {
            request.addHeader("Content-Type", StringUtils.fromString((String)copyObjectRequest.contentType()));
        }
        if (copyObjectRequest.copySource() != null) {
            request.addHeader("x-amz-copy-source", StringUtils.fromString((String)copyObjectRequest.copySource()));
        }
        if (copyObjectRequest.copySourceIfMatch() != null) {
            request.addHeader("x-amz-copy-source-if-match", StringUtils.fromString((String)copyObjectRequest.copySourceIfMatch()));
        }
        if (copyObjectRequest.copySourceIfModifiedSince() != null) {
            request.addHeader("x-amz-copy-source-if-modified-since", StringUtils.fromInstant((Instant)copyObjectRequest.copySourceIfModifiedSince()));
        }
        if (copyObjectRequest.copySourceIfNoneMatch() != null) {
            request.addHeader("x-amz-copy-source-if-none-match", StringUtils.fromString((String)copyObjectRequest.copySourceIfNoneMatch()));
        }
        if (copyObjectRequest.copySourceIfUnmodifiedSince() != null) {
            request.addHeader("x-amz-copy-source-if-unmodified-since", StringUtils.fromInstant((Instant)copyObjectRequest.copySourceIfUnmodifiedSince()));
        }
        if (copyObjectRequest.expires() != null) {
            request.addHeader("Expires", StringUtils.fromInstant((Instant)copyObjectRequest.expires()));
        }
        if (copyObjectRequest.grantFullControl() != null) {
            request.addHeader("x-amz-grant-full-control", StringUtils.fromString((String)copyObjectRequest.grantFullControl()));
        }
        if (copyObjectRequest.grantRead() != null) {
            request.addHeader("x-amz-grant-read", StringUtils.fromString((String)copyObjectRequest.grantRead()));
        }
        if (copyObjectRequest.grantReadACP() != null) {
            request.addHeader("x-amz-grant-read-acp", StringUtils.fromString((String)copyObjectRequest.grantReadACP()));
        }
        if (copyObjectRequest.grantWriteACP() != null) {
            request.addHeader("x-amz-grant-write-acp", StringUtils.fromString((String)copyObjectRequest.grantWriteACP()));
        }
        if (copyObjectRequest.metadataDirective() != null) {
            request.addHeader("x-amz-metadata-directive", StringUtils.fromString((String)copyObjectRequest.metadataDirective()));
        }
        if (copyObjectRequest.taggingDirective() != null) {
            request.addHeader("x-amz-tagging-directive", StringUtils.fromString((String)copyObjectRequest.taggingDirective()));
        }
        if (copyObjectRequest.serverSideEncryption() != null) {
            request.addHeader("x-amz-server-side-encryption", StringUtils.fromString((String)copyObjectRequest.serverSideEncryption()));
        }
        if (copyObjectRequest.storageClass() != null) {
            request.addHeader("x-amz-storage-class", StringUtils.fromString((String)copyObjectRequest.storageClass()));
        }
        if (copyObjectRequest.websiteRedirectLocation() != null) {
            request.addHeader("x-amz-website-redirect-location", StringUtils.fromString((String)copyObjectRequest.websiteRedirectLocation()));
        }
        if (copyObjectRequest.sseCustomerAlgorithm() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-algorithm", StringUtils.fromString((String)copyObjectRequest.sseCustomerAlgorithm()));
        }
        if (copyObjectRequest.sseCustomerKey() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-key", StringUtils.fromString((String)copyObjectRequest.sseCustomerKey()));
        }
        if (copyObjectRequest.sseCustomerKeyMD5() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-key-MD5", StringUtils.fromString((String)copyObjectRequest.sseCustomerKeyMD5()));
        }
        if (copyObjectRequest.ssekmsKeyId() != null) {
            request.addHeader("x-amz-server-side-encryption-aws-kms-key-id", StringUtils.fromString((String)copyObjectRequest.ssekmsKeyId()));
        }
        if (copyObjectRequest.copySourceSSECustomerAlgorithm() != null) {
            request.addHeader("x-amz-copy-source-server-side-encryption-customer-algorithm", StringUtils.fromString((String)copyObjectRequest.copySourceSSECustomerAlgorithm()));
        }
        if (copyObjectRequest.copySourceSSECustomerKey() != null) {
            request.addHeader("x-amz-copy-source-server-side-encryption-customer-key", StringUtils.fromString((String)copyObjectRequest.copySourceSSECustomerKey()));
        }
        if (copyObjectRequest.copySourceSSECustomerKeyMD5() != null) {
            request.addHeader("x-amz-copy-source-server-side-encryption-customer-key-MD5", StringUtils.fromString((String)copyObjectRequest.copySourceSSECustomerKeyMD5()));
        }
        if (copyObjectRequest.requestPayer() != null) {
            request.addHeader("x-amz-request-payer", StringUtils.fromString((String)copyObjectRequest.requestPayer()));
        }
        if (copyObjectRequest.tagging() != null) {
            request.addHeader("x-amz-tagging", StringUtils.fromString((String)copyObjectRequest.tagging()));
        }
        if (copyObjectRequest.metadata() != null) {
            copyObjectRequest.metadata().entrySet().forEach(arg_0 -> CopyObjectRequestMarshaller.lambda$marshall$0((Request)request, arg_0));
        }
        String uriResourcePath = "/{Bucket}/{Key+}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", copyObjectRequest.bucket());
        uriResourcePath = PathMarshallers.GREEDY.marshall(uriResourcePath, "Key", copyObjectRequest.key());
        request.setResourcePath(uriResourcePath);
        return request;
    }

    private static /* synthetic */ void lambda$marshall$0(Request request, Map.Entry e) {
        if (((String)e.getKey()).startsWith("x-amz-meta-")) {
            request.addHeader((String)e.getKey(), (String)e.getValue());
        } else {
            request.addHeader("x-amz-meta-" + (String)e.getKey(), (String)e.getValue());
        }
    }
}

