/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.s3.model.InventoryDestination;
import software.amazon.awssdk.services.s3.model.InventoryFilter;
import software.amazon.awssdk.services.s3.model.InventoryIncludedObjectVersions;
import software.amazon.awssdk.services.s3.model.InventoryOptionalField;
import software.amazon.awssdk.services.s3.model.InventoryOptionalFieldsCopier;
import software.amazon.awssdk.services.s3.model.InventorySchedule;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InventoryConfiguration
implements ToCopyableBuilder<Builder, InventoryConfiguration> {
    private final InventoryDestination destination;
    private final Boolean isEnabled;
    private final InventoryFilter filter;
    private final String id;
    private final String includedObjectVersions;
    private final List<String> optionalFields;
    private final InventorySchedule schedule;

    private InventoryConfiguration(BuilderImpl builder) {
        this.destination = builder.destination;
        this.isEnabled = builder.isEnabled;
        this.filter = builder.filter;
        this.id = builder.id;
        this.includedObjectVersions = builder.includedObjectVersions;
        this.optionalFields = builder.optionalFields;
        this.schedule = builder.schedule;
    }

    public InventoryDestination destination() {
        return this.destination;
    }

    public Boolean isEnabled() {
        return this.isEnabled;
    }

    public InventoryFilter filter() {
        return this.filter;
    }

    public String id() {
        return this.id;
    }

    public String includedObjectVersions() {
        return this.includedObjectVersions;
    }

    public List<String> optionalFields() {
        return this.optionalFields;
    }

    public InventorySchedule schedule() {
        return this.schedule;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.destination() == null ? 0 : this.destination().hashCode());
        hashCode = 31 * hashCode + (this.isEnabled() == null ? 0 : this.isEnabled().hashCode());
        hashCode = 31 * hashCode + (this.filter() == null ? 0 : this.filter().hashCode());
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.includedObjectVersions() == null ? 0 : this.includedObjectVersions().hashCode());
        hashCode = 31 * hashCode + (this.optionalFields() == null ? 0 : this.optionalFields().hashCode());
        hashCode = 31 * hashCode + (this.schedule() == null ? 0 : this.schedule().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InventoryConfiguration)) {
            return false;
        }
        InventoryConfiguration other = (InventoryConfiguration)obj;
        if (other.destination() == null ^ this.destination() == null) {
            return false;
        }
        if (other.destination() != null && !other.destination().equals(this.destination())) {
            return false;
        }
        if (other.isEnabled() == null ^ this.isEnabled() == null) {
            return false;
        }
        if (other.isEnabled() != null && !other.isEnabled().equals(this.isEnabled())) {
            return false;
        }
        if (other.filter() == null ^ this.filter() == null) {
            return false;
        }
        if (other.filter() != null && !other.filter().equals(this.filter())) {
            return false;
        }
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.includedObjectVersions() == null ^ this.includedObjectVersions() == null) {
            return false;
        }
        if (other.includedObjectVersions() != null && !other.includedObjectVersions().equals(this.includedObjectVersions())) {
            return false;
        }
        if (other.optionalFields() == null ^ this.optionalFields() == null) {
            return false;
        }
        if (other.optionalFields() != null && !other.optionalFields().equals(this.optionalFields())) {
            return false;
        }
        if (other.schedule() == null ^ this.schedule() == null) {
            return false;
        }
        return other.schedule() == null || other.schedule().equals(this.schedule());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.destination() != null) {
            sb.append("Destination: ").append(this.destination()).append(",");
        }
        if (this.isEnabled() != null) {
            sb.append("IsEnabled: ").append(this.isEnabled()).append(",");
        }
        if (this.filter() != null) {
            sb.append("Filter: ").append(this.filter()).append(",");
        }
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.includedObjectVersions() != null) {
            sb.append("IncludedObjectVersions: ").append(this.includedObjectVersions()).append(",");
        }
        if (this.optionalFields() != null) {
            sb.append("OptionalFields: ").append(this.optionalFields()).append(",");
        }
        if (this.schedule() != null) {
            sb.append("Schedule: ").append(this.schedule()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private InventoryDestination destination;
        private Boolean isEnabled;
        private InventoryFilter filter;
        private String id;
        private String includedObjectVersions;
        private List<String> optionalFields;
        private InventorySchedule schedule;

        private BuilderImpl() {
        }

        private BuilderImpl(InventoryConfiguration model) {
            this.setDestination(model.destination);
            this.setIsEnabled(model.isEnabled);
            this.setFilter(model.filter);
            this.setId(model.id);
            this.setIncludedObjectVersions(model.includedObjectVersions);
            this.setOptionalFields(model.optionalFields);
            this.setSchedule(model.schedule);
        }

        public final InventoryDestination getDestination() {
            return this.destination;
        }

        @Override
        public final Builder destination(InventoryDestination destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(InventoryDestination destination) {
            this.destination = destination;
        }

        public final Boolean getIsEnabled() {
            return this.isEnabled;
        }

        @Override
        public final Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            return this;
        }

        public final void setIsEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
        }

        public final InventoryFilter getFilter() {
            return this.filter;
        }

        @Override
        public final Builder filter(InventoryFilter filter) {
            this.filter = filter;
            return this;
        }

        public final void setFilter(InventoryFilter filter) {
            this.filter = filter;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getIncludedObjectVersions() {
            return this.includedObjectVersions;
        }

        @Override
        public final Builder includedObjectVersions(String includedObjectVersions) {
            this.includedObjectVersions = includedObjectVersions;
            return this;
        }

        @Override
        public final Builder includedObjectVersions(InventoryIncludedObjectVersions includedObjectVersions) {
            this.includedObjectVersions(includedObjectVersions.toString());
            return this;
        }

        public final void setIncludedObjectVersions(String includedObjectVersions) {
            this.includedObjectVersions = includedObjectVersions;
        }

        public final Collection<String> getOptionalFields() {
            return this.optionalFields;
        }

        @Override
        public final Builder optionalFields(Collection<String> optionalFields) {
            this.optionalFields = InventoryOptionalFieldsCopier.copy(optionalFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionalFields(String ... optionalFields) {
            this.optionalFields(Arrays.asList(optionalFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionalFields(InventoryOptionalField ... optionalFields) {
            this.optionalFields(Arrays.asList(optionalFields).stream().map(Object::toString).collect(Collectors.toList()));
            return this;
        }

        public final void setOptionalFields(Collection<String> optionalFields) {
            this.optionalFields = InventoryOptionalFieldsCopier.copy(optionalFields);
        }

        public final InventorySchedule getSchedule() {
            return this.schedule;
        }

        @Override
        public final Builder schedule(InventorySchedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public final void setSchedule(InventorySchedule schedule) {
            this.schedule = schedule;
        }

        public InventoryConfiguration build() {
            return new InventoryConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InventoryConfiguration> {
        public Builder destination(InventoryDestination var1);

        public Builder isEnabled(Boolean var1);

        public Builder filter(InventoryFilter var1);

        public Builder id(String var1);

        public Builder includedObjectVersions(String var1);

        public Builder includedObjectVersions(InventoryIncludedObjectVersions var1);

        public Builder optionalFields(Collection<String> var1);

        public Builder optionalFields(String ... var1);

        public Builder optionalFields(InventoryOptionalField ... var1);

        public Builder schedule(InventorySchedule var1);
    }
}

