/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import software.amazon.awssdk.services.s3.model.Grantee;
import software.amazon.awssdk.services.s3.model.Permission;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Grant
implements ToCopyableBuilder<Builder, Grant> {
    private final Grantee grantee;
    private final String permission;

    private Grant(BuilderImpl builder) {
        this.grantee = builder.grantee;
        this.permission = builder.permission;
    }

    public Grantee grantee() {
        return this.grantee;
    }

    public String permission() {
        return this.permission;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.grantee() == null ? 0 : this.grantee().hashCode());
        hashCode = 31 * hashCode + (this.permission() == null ? 0 : this.permission().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Grant)) {
            return false;
        }
        Grant other = (Grant)obj;
        if (other.grantee() == null ^ this.grantee() == null) {
            return false;
        }
        if (other.grantee() != null && !other.grantee().equals(this.grantee())) {
            return false;
        }
        if (other.permission() == null ^ this.permission() == null) {
            return false;
        }
        return other.permission() == null || other.permission().equals(this.permission());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.grantee() != null) {
            sb.append("Grantee: ").append(this.grantee()).append(",");
        }
        if (this.permission() != null) {
            sb.append("Permission: ").append(this.permission()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Grantee grantee;
        private String permission;

        private BuilderImpl() {
        }

        private BuilderImpl(Grant model) {
            this.setGrantee(model.grantee);
            this.setPermission(model.permission);
        }

        public final Grantee getGrantee() {
            return this.grantee;
        }

        @Override
        public final Builder grantee(Grantee grantee) {
            this.grantee = grantee;
            return this;
        }

        public final void setGrantee(Grantee grantee) {
            this.grantee = grantee;
        }

        public final String getPermission() {
            return this.permission;
        }

        @Override
        public final Builder permission(String permission) {
            this.permission = permission;
            return this;
        }

        @Override
        public final Builder permission(Permission permission) {
            this.permission(permission.toString());
            return this;
        }

        public final void setPermission(String permission) {
            this.permission = permission;
        }

        public Grant build() {
            return new Grant(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Grant> {
        public Builder grantee(Grantee var1);

        public Builder permission(String var1);

        public Builder permission(Permission var1);
    }
}

