/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.LifecycleConfiguration;
import software.amazon.awssdk.services.s3.model.Rule;
import software.amazon.awssdk.services.s3.transform.RuleUnmarshaller;

public class LifecycleConfigurationUnmarshaller
implements Unmarshaller<LifecycleConfiguration, StaxUnmarshallerContext> {
    private static final LifecycleConfigurationUnmarshaller INSTANCE = new LifecycleConfigurationUnmarshaller();

    public LifecycleConfiguration unmarshall(StaxUnmarshallerContext context) throws Exception {
        LifecycleConfiguration.Builder lifecycleConfiguration;
        block5: {
            lifecycleConfiguration = LifecycleConfiguration.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<Rule> rules = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    lifecycleConfiguration.rules(rules);
                    break block5;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (!context.testExpression("Rule", targetDepth)) continue;
                    if (rules == null) {
                        rules = new ArrayList<Rule>();
                    }
                    rules.add(RuleUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            lifecycleConfiguration.rules(rules);
        }
        return (LifecycleConfiguration)lifecycleConfiguration.build();
    }

    public static LifecycleConfigurationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

