/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.s3.model.Event;
import software.amazon.awssdk.services.s3.model.EventListCopier;
import software.amazon.awssdk.services.s3.model.NotificationConfigurationFilter;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TopicConfiguration
implements ToCopyableBuilder<Builder, TopicConfiguration> {
    private final String id;
    private final String topicArn;
    private final List<String> events;
    private final NotificationConfigurationFilter filter;

    private TopicConfiguration(BuilderImpl builder) {
        this.id = builder.id;
        this.topicArn = builder.topicArn;
        this.events = builder.events;
        this.filter = builder.filter;
    }

    public String id() {
        return this.id;
    }

    public String topicArn() {
        return this.topicArn;
    }

    public List<String> events() {
        return this.events;
    }

    public NotificationConfigurationFilter filter() {
        return this.filter;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.topicArn() == null ? 0 : this.topicArn().hashCode());
        hashCode = 31 * hashCode + (this.events() == null ? 0 : this.events().hashCode());
        hashCode = 31 * hashCode + (this.filter() == null ? 0 : this.filter().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicConfiguration)) {
            return false;
        }
        TopicConfiguration other = (TopicConfiguration)obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.topicArn() == null ^ this.topicArn() == null) {
            return false;
        }
        if (other.topicArn() != null && !other.topicArn().equals(this.topicArn())) {
            return false;
        }
        if (other.events() == null ^ this.events() == null) {
            return false;
        }
        if (other.events() != null && !other.events().equals(this.events())) {
            return false;
        }
        if (other.filter() == null ^ this.filter() == null) {
            return false;
        }
        return other.filter() == null || other.filter().equals(this.filter());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.topicArn() != null) {
            sb.append("TopicArn: ").append(this.topicArn()).append(",");
        }
        if (this.events() != null) {
            sb.append("Events: ").append(this.events()).append(",");
        }
        if (this.filter() != null) {
            sb.append("Filter: ").append(this.filter()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String id;
        private String topicArn;
        private List<String> events;
        private NotificationConfigurationFilter filter;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicConfiguration model) {
            this.setId(model.id);
            this.setTopicArn(model.topicArn);
            this.setEvents(model.events);
            this.setFilter(model.filter);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getTopicArn() {
            return this.topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        public final Collection<String> getEvents() {
            return this.events;
        }

        @Override
        public final Builder events(Collection<String> events) {
            this.events = EventListCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(String ... events) {
            this.events(Arrays.asList(events));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(Event ... events) {
            this.events(Arrays.asList(events).stream().map(Object::toString).collect(Collectors.toList()));
            return this;
        }

        public final void setEvents(Collection<String> events) {
            this.events = EventListCopier.copy(events);
        }

        public final NotificationConfigurationFilter getFilter() {
            return this.filter;
        }

        @Override
        public final Builder filter(NotificationConfigurationFilter filter) {
            this.filter = filter;
            return this;
        }

        public final void setFilter(NotificationConfigurationFilter filter) {
            this.filter = filter;
        }

        public TopicConfiguration build() {
            return new TopicConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TopicConfiguration> {
        public Builder id(String var1);

        public Builder topicArn(String var1);

        public Builder events(Collection<String> var1);

        public Builder events(String ... var1);

        public Builder events(Event ... var1);

        public Builder filter(NotificationConfigurationFilter var1);
    }
}

