/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.s3.model.DeletedObject;
import software.amazon.awssdk.services.s3.model.DeletedObjectsCopier;
import software.amazon.awssdk.services.s3.model.ErrorsCopier;
import software.amazon.awssdk.services.s3.model.RequestCharged;
import software.amazon.awssdk.services.s3.model.S3Error;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteObjectsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DeleteObjectsResponse> {
    private final List<DeletedObject> deleted;
    private final String requestCharged;
    private final List<S3Error> errors;

    private DeleteObjectsResponse(BuilderImpl builder) {
        this.deleted = builder.deleted;
        this.requestCharged = builder.requestCharged;
        this.errors = builder.errors;
    }

    public List<DeletedObject> deleted() {
        return this.deleted;
    }

    public String requestCharged() {
        return this.requestCharged;
    }

    public List<S3Error> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.deleted() == null ? 0 : this.deleted().hashCode());
        hashCode = 31 * hashCode + (this.requestCharged() == null ? 0 : this.requestCharged().hashCode());
        hashCode = 31 * hashCode + (this.errors() == null ? 0 : this.errors().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteObjectsResponse)) {
            return false;
        }
        DeleteObjectsResponse other = (DeleteObjectsResponse)((Object)obj);
        if (other.deleted() == null ^ this.deleted() == null) {
            return false;
        }
        if (other.deleted() != null && !other.deleted().equals(this.deleted())) {
            return false;
        }
        if (other.requestCharged() == null ^ this.requestCharged() == null) {
            return false;
        }
        if (other.requestCharged() != null && !other.requestCharged().equals(this.requestCharged())) {
            return false;
        }
        if (other.errors() == null ^ this.errors() == null) {
            return false;
        }
        return other.errors() == null || other.errors().equals(this.errors());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.deleted() != null) {
            sb.append("Deleted: ").append(this.deleted()).append(",");
        }
        if (this.requestCharged() != null) {
            sb.append("RequestCharged: ").append(this.requestCharged()).append(",");
        }
        if (this.errors() != null) {
            sb.append("Errors: ").append(this.errors()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<DeletedObject> deleted;
        private String requestCharged;
        private List<S3Error> errors;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteObjectsResponse model) {
            this.setDeleted(model.deleted);
            this.setRequestCharged(model.requestCharged);
            this.setErrors(model.errors);
        }

        public final Collection<DeletedObject> getDeleted() {
            return this.deleted;
        }

        @Override
        public final Builder deleted(Collection<DeletedObject> deleted) {
            this.deleted = DeletedObjectsCopier.copy(deleted);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deleted(DeletedObject ... deleted) {
            this.deleted(Arrays.asList(deleted));
            return this;
        }

        public final void setDeleted(Collection<DeletedObject> deleted) {
            this.deleted = DeletedObjectsCopier.copy(deleted);
        }

        public final String getRequestCharged() {
            return this.requestCharged;
        }

        @Override
        public final Builder requestCharged(String requestCharged) {
            this.requestCharged = requestCharged;
            return this;
        }

        @Override
        public final Builder requestCharged(RequestCharged requestCharged) {
            this.requestCharged(requestCharged.toString());
            return this;
        }

        public final void setRequestCharged(String requestCharged) {
            this.requestCharged = requestCharged;
        }

        public final Collection<S3Error> getErrors() {
            return this.errors;
        }

        @Override
        public final Builder errors(Collection<S3Error> errors) {
            this.errors = ErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(S3Error ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        public final void setErrors(Collection<S3Error> errors) {
            this.errors = ErrorsCopier.copy(errors);
        }

        public DeleteObjectsResponse build() {
            return new DeleteObjectsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeleteObjectsResponse> {
        public Builder deleted(Collection<DeletedObject> var1);

        public Builder deleted(DeletedObject ... var1);

        public Builder requestCharged(String var1);

        public Builder requestCharged(RequestCharged var1);

        public Builder errors(Collection<S3Error> var1);

        public Builder errors(S3Error ... var1);
    }
}

