/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.PathMarshallers;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;
import software.amazon.awssdk.util.StringUtils;

public class UploadPartRequestMarshaller
implements Marshaller<Request<UploadPartRequest>, UploadPartRequest> {
    public Request<UploadPartRequest> marshall(UploadPartRequest uploadPartRequest) {
        if (uploadPartRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)uploadPartRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.PUT);
        if (uploadPartRequest.contentLength() != null) {
            request.addHeader("Content-Length", StringUtils.fromLong((Long)uploadPartRequest.contentLength()));
        }
        if (uploadPartRequest.contentMD5() != null) {
            request.addHeader("Content-MD5", StringUtils.fromString((String)uploadPartRequest.contentMD5()));
        }
        if (uploadPartRequest.sseCustomerAlgorithm() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-algorithm", StringUtils.fromString((String)uploadPartRequest.sseCustomerAlgorithm()));
        }
        if (uploadPartRequest.sseCustomerKey() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-key", StringUtils.fromString((String)uploadPartRequest.sseCustomerKey()));
        }
        if (uploadPartRequest.sseCustomerKeyMD5() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-key-MD5", StringUtils.fromString((String)uploadPartRequest.sseCustomerKeyMD5()));
        }
        if (uploadPartRequest.requestPayer() != null) {
            request.addHeader("x-amz-request-payer", StringUtils.fromString((String)uploadPartRequest.requestPayer()));
        }
        String uriResourcePath = "/{Bucket}/{Key+}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", uploadPartRequest.bucket());
        uriResourcePath = PathMarshallers.GREEDY.marshall(uriResourcePath, "Key", uploadPartRequest.key());
        request.setResourcePath(uriResourcePath);
        if (uploadPartRequest.partNumber() != null) {
            request.addParameter("partNumber", StringUtils.fromInteger((Integer)uploadPartRequest.partNumber()));
        }
        if (uploadPartRequest.uploadId() != null) {
            request.addParameter("uploadId", StringUtils.fromString((String)uploadPartRequest.uploadId()));
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "binary/octet-stream");
        }
        return request;
    }
}

