/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.PathMarshallers;
import software.amazon.awssdk.services.s3.model.Destination;
import software.amazon.awssdk.services.s3.model.PutBucketReplicationRequest;
import software.amazon.awssdk.services.s3.model.ReplicationConfiguration;
import software.amazon.awssdk.services.s3.model.ReplicationRule;
import software.amazon.awssdk.util.Md5Utils;
import software.amazon.awssdk.util.StringInputStream;
import software.amazon.awssdk.util.StringUtils;
import software.amazon.awssdk.util.UriResourcePathUtils;
import software.amazon.awssdk.util.XmlWriter;

public class PutBucketReplicationRequestMarshaller
implements Marshaller<Request<PutBucketReplicationRequest>, PutBucketReplicationRequest> {
    public Request<PutBucketReplicationRequest> marshall(PutBucketReplicationRequest putBucketReplicationRequest) {
        if (putBucketReplicationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putBucketReplicationRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.PUT);
        if (putBucketReplicationRequest.contentMD5() != null) {
            request.addHeader("Content-MD5", StringUtils.fromString((String)putBucketReplicationRequest.contentMD5()));
        }
        String uriResourcePath = "/{Bucket}?replication";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParamtersToRequest((Request)request, (String)uriResourcePath);
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", putBucketReplicationRequest.bucket());
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = null;
            ReplicationConfiguration replicationConfiguration = putBucketReplicationRequest.replicationConfiguration();
            if (replicationConfiguration != null) {
                List<ReplicationRule> replicationConfigurationRulesList;
                stringWriter = new StringWriter();
                XmlWriter xmlWriter = new XmlWriter((Writer)stringWriter, "http://s3.amazonaws.com/doc/2006-03-01/");
                xmlWriter.startElement("ReplicationConfiguration");
                if (replicationConfiguration.role() != null) {
                    xmlWriter.startElement("Role").value(replicationConfiguration.role()).endElement();
                }
                if ((replicationConfigurationRulesList = replicationConfiguration.rules()) != null) {
                    for (ReplicationRule replicationConfigurationRulesListValue : replicationConfigurationRulesList) {
                        Destination destination;
                        xmlWriter.startElement("Rule");
                        if (replicationConfigurationRulesListValue.id() != null) {
                            xmlWriter.startElement("ID").value(replicationConfigurationRulesListValue.id()).endElement();
                        }
                        if (replicationConfigurationRulesListValue.prefix() != null) {
                            xmlWriter.startElement("Prefix").value(replicationConfigurationRulesListValue.prefix()).endElement();
                        }
                        if (replicationConfigurationRulesListValue.status() != null) {
                            xmlWriter.startElement("Status").value(replicationConfigurationRulesListValue.status()).endElement();
                        }
                        if ((destination = replicationConfigurationRulesListValue.destination()) != null) {
                            xmlWriter.startElement("Destination");
                            if (destination.bucket() != null) {
                                xmlWriter.startElement("Bucket").value(destination.bucket()).endElement();
                            }
                            if (destination.storageClass() != null) {
                                xmlWriter.startElement("StorageClass").value(destination.storageClass()).endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                }
                xmlWriter.endElement();
            }
            if (stringWriter != null) {
                if (!request.getHeaders().containsKey("Content-MD5")) {
                    request.addHeader("Content-MD5", Md5Utils.md5AsBase64((byte[])stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8)));
                }
                request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
                request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            }
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

