/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.LifecycleRule;
import software.amazon.awssdk.services.s3.model.NoncurrentVersionTransition;
import software.amazon.awssdk.services.s3.model.Transition;
import software.amazon.awssdk.services.s3.transform.AbortIncompleteMultipartUploadUnmarshaller;
import software.amazon.awssdk.services.s3.transform.LifecycleExpirationUnmarshaller;
import software.amazon.awssdk.services.s3.transform.LifecycleRuleFilterUnmarshaller;
import software.amazon.awssdk.services.s3.transform.NoncurrentVersionExpirationUnmarshaller;
import software.amazon.awssdk.services.s3.transform.NoncurrentVersionTransitionUnmarshaller;
import software.amazon.awssdk.services.s3.transform.TransitionUnmarshaller;

public class LifecycleRuleUnmarshaller
implements Unmarshaller<LifecycleRule, StaxUnmarshallerContext> {
    private static LifecycleRuleUnmarshaller INSTANCE;

    public LifecycleRule unmarshall(StaxUnmarshallerContext context) throws Exception {
        LifecycleRule.Builder lifecycleRule;
        block14: {
            lifecycleRule = LifecycleRule.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<Transition> transitions = null;
            ArrayList<NoncurrentVersionTransition> noncurrentVersionTransitions = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    lifecycleRule.transitions(transitions);
                    lifecycleRule.noncurrentVersionTransitions(noncurrentVersionTransitions);
                    break block14;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("Expiration", targetDepth)) {
                        lifecycleRule.expiration(LifecycleExpirationUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ID", targetDepth)) {
                        lifecycleRule.id(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Prefix", targetDepth)) {
                        lifecycleRule.prefix(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Filter", targetDepth)) {
                        lifecycleRule.filter(LifecycleRuleFilterUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Status", targetDepth)) {
                        lifecycleRule.status(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Transition", targetDepth)) {
                        if (transitions == null) {
                            transitions = new ArrayList<Transition>();
                        }
                        transitions.add(TransitionUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("NoncurrentVersionTransition", targetDepth)) {
                        if (noncurrentVersionTransitions == null) {
                            noncurrentVersionTransitions = new ArrayList<NoncurrentVersionTransition>();
                        }
                        noncurrentVersionTransitions.add(NoncurrentVersionTransitionUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("NoncurrentVersionExpiration", targetDepth)) {
                        lifecycleRule.noncurrentVersionExpiration(NoncurrentVersionExpirationUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("AbortIncompleteMultipartUpload", targetDepth)) continue;
                    lifecycleRule.abortIncompleteMultipartUpload(AbortIncompleteMultipartUploadUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            lifecycleRule.transitions(transitions);
            lifecycleRule.noncurrentVersionTransitions(noncurrentVersionTransitions);
        }
        return (LifecycleRule)lifecycleRule.build();
    }

    public static LifecycleRuleUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new LifecycleRuleUnmarshaller();
        }
        return INSTANCE;
    }
}

