/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.InventoryConfiguration;
import software.amazon.awssdk.services.s3.transform.InventoryDestinationUnmarshaller;
import software.amazon.awssdk.services.s3.transform.InventoryFilterUnmarshaller;
import software.amazon.awssdk.services.s3.transform.InventoryScheduleUnmarshaller;

public class InventoryConfigurationUnmarshaller
implements Unmarshaller<InventoryConfiguration, StaxUnmarshallerContext> {
    private static InventoryConfigurationUnmarshaller INSTANCE;

    public InventoryConfiguration unmarshall(StaxUnmarshallerContext context) throws Exception {
        InventoryConfiguration.Builder inventoryConfiguration;
        block11: {
            inventoryConfiguration = InventoryConfiguration.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<String> optionalFields = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    inventoryConfiguration.optionalFields(optionalFields);
                    break block11;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("Destination", targetDepth)) {
                        inventoryConfiguration.destination(InventoryDestinationUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("IsEnabled", targetDepth)) {
                        inventoryConfiguration.isEnabled(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Filter", targetDepth)) {
                        inventoryConfiguration.filter(InventoryFilterUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Id", targetDepth)) {
                        inventoryConfiguration.id(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("IncludedObjectVersions", targetDepth)) {
                        inventoryConfiguration.includedObjectVersions(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("OptionalFields", targetDepth)) {
                        optionalFields = new ArrayList<String>();
                        continue;
                    }
                    if (context.testExpression("OptionalFields/Field", targetDepth)) {
                        optionalFields.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("Schedule", targetDepth)) continue;
                    inventoryConfiguration.schedule(InventoryScheduleUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            inventoryConfiguration.optionalFields(optionalFields);
        }
        return (InventoryConfiguration)inventoryConfiguration.build();
    }

    public static InventoryConfigurationUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new InventoryConfigurationUnmarshaller();
        }
        return INSTANCE;
    }
}

