/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.s3.model.RequestCharged;
import software.amazon.awssdk.services.s3.model.ServerSideEncryption;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UploadPartResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, UploadPartResponse> {
    private final String serverSideEncryption;
    private final String eTag;
    private final String sseCustomerAlgorithm;
    private final String sseCustomerKeyMD5;
    private final String ssekmsKeyId;
    private final String requestCharged;

    private UploadPartResponse(BuilderImpl builder) {
        this.serverSideEncryption = builder.serverSideEncryption;
        this.eTag = builder.eTag;
        this.sseCustomerAlgorithm = builder.sseCustomerAlgorithm;
        this.sseCustomerKeyMD5 = builder.sseCustomerKeyMD5;
        this.ssekmsKeyId = builder.ssekmsKeyId;
        this.requestCharged = builder.requestCharged;
    }

    public String serverSideEncryption() {
        return this.serverSideEncryption;
    }

    public String eTag() {
        return this.eTag;
    }

    public String sseCustomerAlgorithm() {
        return this.sseCustomerAlgorithm;
    }

    public String sseCustomerKeyMD5() {
        return this.sseCustomerKeyMD5;
    }

    public String ssekmsKeyId() {
        return this.ssekmsKeyId;
    }

    public String requestCharged() {
        return this.requestCharged;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.serverSideEncryption() == null ? 0 : this.serverSideEncryption().hashCode());
        hashCode = 31 * hashCode + (this.eTag() == null ? 0 : this.eTag().hashCode());
        hashCode = 31 * hashCode + (this.sseCustomerAlgorithm() == null ? 0 : this.sseCustomerAlgorithm().hashCode());
        hashCode = 31 * hashCode + (this.sseCustomerKeyMD5() == null ? 0 : this.sseCustomerKeyMD5().hashCode());
        hashCode = 31 * hashCode + (this.ssekmsKeyId() == null ? 0 : this.ssekmsKeyId().hashCode());
        hashCode = 31 * hashCode + (this.requestCharged() == null ? 0 : this.requestCharged().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UploadPartResponse)) {
            return false;
        }
        UploadPartResponse other = (UploadPartResponse)((Object)obj);
        if (other.serverSideEncryption() == null ^ this.serverSideEncryption() == null) {
            return false;
        }
        if (other.serverSideEncryption() != null && !other.serverSideEncryption().equals(this.serverSideEncryption())) {
            return false;
        }
        if (other.eTag() == null ^ this.eTag() == null) {
            return false;
        }
        if (other.eTag() != null && !other.eTag().equals(this.eTag())) {
            return false;
        }
        if (other.sseCustomerAlgorithm() == null ^ this.sseCustomerAlgorithm() == null) {
            return false;
        }
        if (other.sseCustomerAlgorithm() != null && !other.sseCustomerAlgorithm().equals(this.sseCustomerAlgorithm())) {
            return false;
        }
        if (other.sseCustomerKeyMD5() == null ^ this.sseCustomerKeyMD5() == null) {
            return false;
        }
        if (other.sseCustomerKeyMD5() != null && !other.sseCustomerKeyMD5().equals(this.sseCustomerKeyMD5())) {
            return false;
        }
        if (other.ssekmsKeyId() == null ^ this.ssekmsKeyId() == null) {
            return false;
        }
        if (other.ssekmsKeyId() != null && !other.ssekmsKeyId().equals(this.ssekmsKeyId())) {
            return false;
        }
        if (other.requestCharged() == null ^ this.requestCharged() == null) {
            return false;
        }
        return other.requestCharged() == null || other.requestCharged().equals(this.requestCharged());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.serverSideEncryption() != null) {
            sb.append("ServerSideEncryption: ").append(this.serverSideEncryption()).append(",");
        }
        if (this.eTag() != null) {
            sb.append("ETag: ").append(this.eTag()).append(",");
        }
        if (this.sseCustomerAlgorithm() != null) {
            sb.append("SSECustomerAlgorithm: ").append(this.sseCustomerAlgorithm()).append(",");
        }
        if (this.sseCustomerKeyMD5() != null) {
            sb.append("SSECustomerKeyMD5: ").append(this.sseCustomerKeyMD5()).append(",");
        }
        if (this.ssekmsKeyId() != null) {
            sb.append("SSEKMSKeyId: ").append(this.ssekmsKeyId()).append(",");
        }
        if (this.requestCharged() != null) {
            sb.append("RequestCharged: ").append(this.requestCharged()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String serverSideEncryption;
        private String eTag;
        private String sseCustomerAlgorithm;
        private String sseCustomerKeyMD5;
        private String ssekmsKeyId;
        private String requestCharged;

        private BuilderImpl() {
        }

        private BuilderImpl(UploadPartResponse model) {
            this.setServerSideEncryption(model.serverSideEncryption);
            this.setETag(model.eTag);
            this.setSSECustomerAlgorithm(model.sseCustomerAlgorithm);
            this.setSSECustomerKeyMD5(model.sseCustomerKeyMD5);
            this.setSSEKMSKeyId(model.ssekmsKeyId);
            this.setRequestCharged(model.requestCharged);
        }

        public final String getServerSideEncryption() {
            return this.serverSideEncryption;
        }

        @Override
        public final Builder serverSideEncryption(String serverSideEncryption) {
            this.serverSideEncryption = serverSideEncryption;
            return this;
        }

        @Override
        public final Builder serverSideEncryption(ServerSideEncryption serverSideEncryption) {
            this.serverSideEncryption(serverSideEncryption.toString());
            return this;
        }

        public final void setServerSideEncryption(String serverSideEncryption) {
            this.serverSideEncryption = serverSideEncryption;
        }

        public final void setServerSideEncryption(ServerSideEncryption serverSideEncryption) {
            this.serverSideEncryption(serverSideEncryption.toString());
        }

        public final String getETag() {
            return this.eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        public final String getSSECustomerAlgorithm() {
            return this.sseCustomerAlgorithm;
        }

        @Override
        public final Builder sseCustomerAlgorithm(String sseCustomerAlgorithm) {
            this.sseCustomerAlgorithm = sseCustomerAlgorithm;
            return this;
        }

        public final void setSSECustomerAlgorithm(String sseCustomerAlgorithm) {
            this.sseCustomerAlgorithm = sseCustomerAlgorithm;
        }

        public final String getSSECustomerKeyMD5() {
            return this.sseCustomerKeyMD5;
        }

        @Override
        public final Builder sseCustomerKeyMD5(String sseCustomerKeyMD5) {
            this.sseCustomerKeyMD5 = sseCustomerKeyMD5;
            return this;
        }

        public final void setSSECustomerKeyMD5(String sseCustomerKeyMD5) {
            this.sseCustomerKeyMD5 = sseCustomerKeyMD5;
        }

        public final String getSSEKMSKeyId() {
            return this.ssekmsKeyId;
        }

        @Override
        public final Builder ssekmsKeyId(String ssekmsKeyId) {
            this.ssekmsKeyId = ssekmsKeyId;
            return this;
        }

        public final void setSSEKMSKeyId(String ssekmsKeyId) {
            this.ssekmsKeyId = ssekmsKeyId;
        }

        public final String getRequestCharged() {
            return this.requestCharged;
        }

        @Override
        public final Builder requestCharged(String requestCharged) {
            this.requestCharged = requestCharged;
            return this;
        }

        @Override
        public final Builder requestCharged(RequestCharged requestCharged) {
            this.requestCharged(requestCharged.toString());
            return this;
        }

        public final void setRequestCharged(String requestCharged) {
            this.requestCharged = requestCharged;
        }

        public final void setRequestCharged(RequestCharged requestCharged) {
            this.requestCharged(requestCharged.toString());
        }

        public UploadPartResponse build() {
            return new UploadPartResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UploadPartResponse> {
        public Builder serverSideEncryption(String var1);

        public Builder serverSideEncryption(ServerSideEncryption var1);

        public Builder eTag(String var1);

        public Builder sseCustomerAlgorithm(String var1);

        public Builder sseCustomerKeyMD5(String var1);

        public Builder ssekmsKeyId(String var1);

        public Builder requestCharged(String var1);

        public Builder requestCharged(RequestCharged var1);
    }
}

