/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.s3.model.AccelerateConfiguration;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutBucketAccelerateConfigurationRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, PutBucketAccelerateConfigurationRequest> {
    private final String bucket;
    private final AccelerateConfiguration accelerateConfiguration;

    private PutBucketAccelerateConfigurationRequest(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.accelerateConfiguration = builder.accelerateConfiguration;
    }

    public String bucket() {
        return this.bucket;
    }

    public AccelerateConfiguration accelerateConfiguration() {
        return this.accelerateConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.bucket() == null ? 0 : this.bucket().hashCode());
        hashCode = 31 * hashCode + (this.accelerateConfiguration() == null ? 0 : this.accelerateConfiguration().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutBucketAccelerateConfigurationRequest)) {
            return false;
        }
        PutBucketAccelerateConfigurationRequest other = (PutBucketAccelerateConfigurationRequest)((Object)obj);
        if (other.bucket() == null ^ this.bucket() == null) {
            return false;
        }
        if (other.bucket() != null && !other.bucket().equals(this.bucket())) {
            return false;
        }
        if (other.accelerateConfiguration() == null ^ this.accelerateConfiguration() == null) {
            return false;
        }
        return other.accelerateConfiguration() == null || other.accelerateConfiguration().equals(this.accelerateConfiguration());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.bucket() != null) {
            sb.append("Bucket: ").append(this.bucket()).append(",");
        }
        if (this.accelerateConfiguration() != null) {
            sb.append("AccelerateConfiguration: ").append(this.accelerateConfiguration()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String bucket;
        private AccelerateConfiguration accelerateConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PutBucketAccelerateConfigurationRequest model) {
            this.setBucket(model.bucket);
            this.setAccelerateConfiguration(model.accelerateConfiguration);
        }

        public final String getBucket() {
            return this.bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final AccelerateConfiguration getAccelerateConfiguration() {
            return this.accelerateConfiguration;
        }

        @Override
        public final Builder accelerateConfiguration(AccelerateConfiguration accelerateConfiguration) {
            this.accelerateConfiguration = accelerateConfiguration;
            return this;
        }

        public final void setAccelerateConfiguration(AccelerateConfiguration accelerateConfiguration) {
            this.accelerateConfiguration = accelerateConfiguration;
        }

        public PutBucketAccelerateConfigurationRequest build() {
            return new PutBucketAccelerateConfigurationRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PutBucketAccelerateConfigurationRequest> {
        public Builder bucket(String var1);

        public Builder accelerateConfiguration(AccelerateConfiguration var1);
    }
}

