/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.time.Instant;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Part
implements ToCopyableBuilder<Builder, Part> {
    private final Integer partNumber;
    private final Instant lastModified;
    private final String eTag;
    private final Integer size;

    private Part(BuilderImpl builder) {
        this.partNumber = builder.partNumber;
        this.lastModified = builder.lastModified;
        this.eTag = builder.eTag;
        this.size = builder.size;
    }

    public Integer partNumber() {
        return this.partNumber;
    }

    public Instant lastModified() {
        return this.lastModified;
    }

    public String eTag() {
        return this.eTag;
    }

    public Integer size() {
        return this.size;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.partNumber() == null ? 0 : this.partNumber().hashCode());
        hashCode = 31 * hashCode + (this.lastModified() == null ? 0 : this.lastModified().hashCode());
        hashCode = 31 * hashCode + (this.eTag() == null ? 0 : this.eTag().hashCode());
        hashCode = 31 * hashCode + (this.size() == null ? 0 : this.size().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Part)) {
            return false;
        }
        Part other = (Part)obj;
        if (other.partNumber() == null ^ this.partNumber() == null) {
            return false;
        }
        if (other.partNumber() != null && !other.partNumber().equals(this.partNumber())) {
            return false;
        }
        if (other.lastModified() == null ^ this.lastModified() == null) {
            return false;
        }
        if (other.lastModified() != null && !other.lastModified().equals(this.lastModified())) {
            return false;
        }
        if (other.eTag() == null ^ this.eTag() == null) {
            return false;
        }
        if (other.eTag() != null && !other.eTag().equals(this.eTag())) {
            return false;
        }
        if (other.size() == null ^ this.size() == null) {
            return false;
        }
        return other.size() == null || other.size().equals(this.size());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.partNumber() != null) {
            sb.append("PartNumber: ").append(this.partNumber()).append(",");
        }
        if (this.lastModified() != null) {
            sb.append("LastModified: ").append(this.lastModified()).append(",");
        }
        if (this.eTag() != null) {
            sb.append("ETag: ").append(this.eTag()).append(",");
        }
        if (this.size() != null) {
            sb.append("Size: ").append(this.size()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Integer partNumber;
        private Instant lastModified;
        private String eTag;
        private Integer size;

        private BuilderImpl() {
        }

        private BuilderImpl(Part model) {
            this.setPartNumber(model.partNumber);
            this.setLastModified(model.lastModified);
            this.setETag(model.eTag);
            this.setSize(model.size);
        }

        public final Integer getPartNumber() {
            return this.partNumber;
        }

        @Override
        public final Builder partNumber(Integer partNumber) {
            this.partNumber = partNumber;
            return this;
        }

        public final void setPartNumber(Integer partNumber) {
            this.partNumber = partNumber;
        }

        public final Instant getLastModified() {
            return this.lastModified;
        }

        @Override
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        public final String getETag() {
            return this.eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        public final Integer getSize() {
            return this.size;
        }

        @Override
        public final Builder size(Integer size) {
            this.size = size;
            return this;
        }

        public final void setSize(Integer size) {
            this.size = size;
        }

        public Part build() {
            return new Part(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Part> {
        public Builder partNumber(Integer var1);

        public Builder lastModified(Instant var1);

        public Builder eTag(String var1);

        public Builder size(Integer var1);
    }
}

