/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.s3.model.TargetGrant;
import software.amazon.awssdk.services.s3.model.TargetGrantsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class LoggingEnabled
implements ToCopyableBuilder<Builder, LoggingEnabled> {
    private final String targetBucket;
    private final List<TargetGrant> targetGrants;
    private final String targetPrefix;

    private LoggingEnabled(BuilderImpl builder) {
        this.targetBucket = builder.targetBucket;
        this.targetGrants = builder.targetGrants;
        this.targetPrefix = builder.targetPrefix;
    }

    public String targetBucket() {
        return this.targetBucket;
    }

    public List<TargetGrant> targetGrants() {
        return this.targetGrants;
    }

    public String targetPrefix() {
        return this.targetPrefix;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.targetBucket() == null ? 0 : this.targetBucket().hashCode());
        hashCode = 31 * hashCode + (this.targetGrants() == null ? 0 : this.targetGrants().hashCode());
        hashCode = 31 * hashCode + (this.targetPrefix() == null ? 0 : this.targetPrefix().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoggingEnabled)) {
            return false;
        }
        LoggingEnabled other = (LoggingEnabled)obj;
        if (other.targetBucket() == null ^ this.targetBucket() == null) {
            return false;
        }
        if (other.targetBucket() != null && !other.targetBucket().equals(this.targetBucket())) {
            return false;
        }
        if (other.targetGrants() == null ^ this.targetGrants() == null) {
            return false;
        }
        if (other.targetGrants() != null && !other.targetGrants().equals(this.targetGrants())) {
            return false;
        }
        if (other.targetPrefix() == null ^ this.targetPrefix() == null) {
            return false;
        }
        return other.targetPrefix() == null || other.targetPrefix().equals(this.targetPrefix());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.targetBucket() != null) {
            sb.append("TargetBucket: ").append(this.targetBucket()).append(",");
        }
        if (this.targetGrants() != null) {
            sb.append("TargetGrants: ").append(this.targetGrants()).append(",");
        }
        if (this.targetPrefix() != null) {
            sb.append("TargetPrefix: ").append(this.targetPrefix()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String targetBucket;
        private List<TargetGrant> targetGrants;
        private String targetPrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(LoggingEnabled model) {
            this.setTargetBucket(model.targetBucket);
            this.setTargetGrants(model.targetGrants);
            this.setTargetPrefix(model.targetPrefix);
        }

        public final String getTargetBucket() {
            return this.targetBucket;
        }

        @Override
        public final Builder targetBucket(String targetBucket) {
            this.targetBucket = targetBucket;
            return this;
        }

        public final void setTargetBucket(String targetBucket) {
            this.targetBucket = targetBucket;
        }

        public final Collection<TargetGrant> getTargetGrants() {
            return this.targetGrants;
        }

        @Override
        public final Builder targetGrants(Collection<TargetGrant> targetGrants) {
            this.targetGrants = TargetGrantsCopier.copy(targetGrants);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetGrants(TargetGrant ... targetGrants) {
            this.targetGrants(Arrays.asList(targetGrants));
            return this;
        }

        public final void setTargetGrants(Collection<TargetGrant> targetGrants) {
            this.targetGrants = TargetGrantsCopier.copy(targetGrants);
        }

        @SafeVarargs
        public final void setTargetGrants(TargetGrant ... targetGrants) {
            this.targetGrants(Arrays.asList(targetGrants));
        }

        public final String getTargetPrefix() {
            return this.targetPrefix;
        }

        @Override
        public final Builder targetPrefix(String targetPrefix) {
            this.targetPrefix = targetPrefix;
            return this;
        }

        public final void setTargetPrefix(String targetPrefix) {
            this.targetPrefix = targetPrefix;
        }

        public LoggingEnabled build() {
            return new LoggingEnabled(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LoggingEnabled> {
        public Builder targetBucket(String var1);

        public Builder targetGrants(Collection<TargetGrant> var1);

        public Builder targetGrants(TargetGrant ... var1);

        public Builder targetPrefix(String var1);
    }
}

