/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.s3.model.CommonPrefix;
import software.amazon.awssdk.services.s3.model.CommonPrefixListCopier;
import software.amazon.awssdk.services.s3.model.EncodingType;
import software.amazon.awssdk.services.s3.model.ObjectListCopier;
import software.amazon.awssdk.services.s3.model.S3Object;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListObjectsV2Response
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListObjectsV2Response> {
    private final Boolean isTruncated;
    private final List<S3Object> contents;
    private final String name;
    private final String prefix;
    private final String delimiter;
    private final Integer maxKeys;
    private final List<CommonPrefix> commonPrefixes;
    private final String encodingType;
    private final Integer keyCount;
    private final String continuationToken;
    private final String nextContinuationToken;
    private final String startAfter;

    private ListObjectsV2Response(BuilderImpl builder) {
        this.isTruncated = builder.isTruncated;
        this.contents = builder.contents;
        this.name = builder.name;
        this.prefix = builder.prefix;
        this.delimiter = builder.delimiter;
        this.maxKeys = builder.maxKeys;
        this.commonPrefixes = builder.commonPrefixes;
        this.encodingType = builder.encodingType;
        this.keyCount = builder.keyCount;
        this.continuationToken = builder.continuationToken;
        this.nextContinuationToken = builder.nextContinuationToken;
        this.startAfter = builder.startAfter;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public List<S3Object> contents() {
        return this.contents;
    }

    public String name() {
        return this.name;
    }

    public String prefix() {
        return this.prefix;
    }

    public String delimiter() {
        return this.delimiter;
    }

    public Integer maxKeys() {
        return this.maxKeys;
    }

    public List<CommonPrefix> commonPrefixes() {
        return this.commonPrefixes;
    }

    public String encodingType() {
        return this.encodingType;
    }

    public Integer keyCount() {
        return this.keyCount;
    }

    public String continuationToken() {
        return this.continuationToken;
    }

    public String nextContinuationToken() {
        return this.nextContinuationToken;
    }

    public String startAfter() {
        return this.startAfter;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.isTruncated() == null ? 0 : this.isTruncated().hashCode());
        hashCode = 31 * hashCode + (this.contents() == null ? 0 : this.contents().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.prefix() == null ? 0 : this.prefix().hashCode());
        hashCode = 31 * hashCode + (this.delimiter() == null ? 0 : this.delimiter().hashCode());
        hashCode = 31 * hashCode + (this.maxKeys() == null ? 0 : this.maxKeys().hashCode());
        hashCode = 31 * hashCode + (this.commonPrefixes() == null ? 0 : this.commonPrefixes().hashCode());
        hashCode = 31 * hashCode + (this.encodingType() == null ? 0 : this.encodingType().hashCode());
        hashCode = 31 * hashCode + (this.keyCount() == null ? 0 : this.keyCount().hashCode());
        hashCode = 31 * hashCode + (this.continuationToken() == null ? 0 : this.continuationToken().hashCode());
        hashCode = 31 * hashCode + (this.nextContinuationToken() == null ? 0 : this.nextContinuationToken().hashCode());
        hashCode = 31 * hashCode + (this.startAfter() == null ? 0 : this.startAfter().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListObjectsV2Response)) {
            return false;
        }
        ListObjectsV2Response other = (ListObjectsV2Response)((Object)obj);
        if (other.isTruncated() == null ^ this.isTruncated() == null) {
            return false;
        }
        if (other.isTruncated() != null && !other.isTruncated().equals(this.isTruncated())) {
            return false;
        }
        if (other.contents() == null ^ this.contents() == null) {
            return false;
        }
        if (other.contents() != null && !other.contents().equals(this.contents())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.prefix() == null ^ this.prefix() == null) {
            return false;
        }
        if (other.prefix() != null && !other.prefix().equals(this.prefix())) {
            return false;
        }
        if (other.delimiter() == null ^ this.delimiter() == null) {
            return false;
        }
        if (other.delimiter() != null && !other.delimiter().equals(this.delimiter())) {
            return false;
        }
        if (other.maxKeys() == null ^ this.maxKeys() == null) {
            return false;
        }
        if (other.maxKeys() != null && !other.maxKeys().equals(this.maxKeys())) {
            return false;
        }
        if (other.commonPrefixes() == null ^ this.commonPrefixes() == null) {
            return false;
        }
        if (other.commonPrefixes() != null && !other.commonPrefixes().equals(this.commonPrefixes())) {
            return false;
        }
        if (other.encodingType() == null ^ this.encodingType() == null) {
            return false;
        }
        if (other.encodingType() != null && !other.encodingType().equals(this.encodingType())) {
            return false;
        }
        if (other.keyCount() == null ^ this.keyCount() == null) {
            return false;
        }
        if (other.keyCount() != null && !other.keyCount().equals(this.keyCount())) {
            return false;
        }
        if (other.continuationToken() == null ^ this.continuationToken() == null) {
            return false;
        }
        if (other.continuationToken() != null && !other.continuationToken().equals(this.continuationToken())) {
            return false;
        }
        if (other.nextContinuationToken() == null ^ this.nextContinuationToken() == null) {
            return false;
        }
        if (other.nextContinuationToken() != null && !other.nextContinuationToken().equals(this.nextContinuationToken())) {
            return false;
        }
        if (other.startAfter() == null ^ this.startAfter() == null) {
            return false;
        }
        return other.startAfter() == null || other.startAfter().equals(this.startAfter());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.isTruncated() != null) {
            sb.append("IsTruncated: ").append(this.isTruncated()).append(",");
        }
        if (this.contents() != null) {
            sb.append("Contents: ").append(this.contents()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.prefix() != null) {
            sb.append("Prefix: ").append(this.prefix()).append(",");
        }
        if (this.delimiter() != null) {
            sb.append("Delimiter: ").append(this.delimiter()).append(",");
        }
        if (this.maxKeys() != null) {
            sb.append("MaxKeys: ").append(this.maxKeys()).append(",");
        }
        if (this.commonPrefixes() != null) {
            sb.append("CommonPrefixes: ").append(this.commonPrefixes()).append(",");
        }
        if (this.encodingType() != null) {
            sb.append("EncodingType: ").append(this.encodingType()).append(",");
        }
        if (this.keyCount() != null) {
            sb.append("KeyCount: ").append(this.keyCount()).append(",");
        }
        if (this.continuationToken() != null) {
            sb.append("ContinuationToken: ").append(this.continuationToken()).append(",");
        }
        if (this.nextContinuationToken() != null) {
            sb.append("NextContinuationToken: ").append(this.nextContinuationToken()).append(",");
        }
        if (this.startAfter() != null) {
            sb.append("StartAfter: ").append(this.startAfter()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Boolean isTruncated;
        private List<S3Object> contents;
        private String name;
        private String prefix;
        private String delimiter;
        private Integer maxKeys;
        private List<CommonPrefix> commonPrefixes;
        private String encodingType;
        private Integer keyCount;
        private String continuationToken;
        private String nextContinuationToken;
        private String startAfter;

        private BuilderImpl() {
        }

        private BuilderImpl(ListObjectsV2Response model) {
            this.setIsTruncated(model.isTruncated);
            this.setContents(model.contents);
            this.setName(model.name);
            this.setPrefix(model.prefix);
            this.setDelimiter(model.delimiter);
            this.setMaxKeys(model.maxKeys);
            this.setCommonPrefixes(model.commonPrefixes);
            this.setEncodingType(model.encodingType);
            this.setKeyCount(model.keyCount);
            this.setContinuationToken(model.continuationToken);
            this.setNextContinuationToken(model.nextContinuationToken);
            this.setStartAfter(model.startAfter);
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final Collection<S3Object> getContents() {
            return this.contents;
        }

        @Override
        public final Builder contents(Collection<S3Object> contents) {
            this.contents = ObjectListCopier.copy(contents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contents(S3Object ... contents) {
            this.contents(Arrays.asList(contents));
            return this;
        }

        public final void setContents(Collection<S3Object> contents) {
            this.contents = ObjectListCopier.copy(contents);
        }

        @SafeVarargs
        public final void setContents(S3Object ... contents) {
            this.contents(Arrays.asList(contents));
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getPrefix() {
            return this.prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public final String getDelimiter() {
            return this.delimiter;
        }

        @Override
        public final Builder delimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public final void setDelimiter(String delimiter) {
            this.delimiter = delimiter;
        }

        public final Integer getMaxKeys() {
            return this.maxKeys;
        }

        @Override
        public final Builder maxKeys(Integer maxKeys) {
            this.maxKeys = maxKeys;
            return this;
        }

        public final void setMaxKeys(Integer maxKeys) {
            this.maxKeys = maxKeys;
        }

        public final Collection<CommonPrefix> getCommonPrefixes() {
            return this.commonPrefixes;
        }

        @Override
        public final Builder commonPrefixes(Collection<CommonPrefix> commonPrefixes) {
            this.commonPrefixes = CommonPrefixListCopier.copy(commonPrefixes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commonPrefixes(CommonPrefix ... commonPrefixes) {
            this.commonPrefixes(Arrays.asList(commonPrefixes));
            return this;
        }

        public final void setCommonPrefixes(Collection<CommonPrefix> commonPrefixes) {
            this.commonPrefixes = CommonPrefixListCopier.copy(commonPrefixes);
        }

        @SafeVarargs
        public final void setCommonPrefixes(CommonPrefix ... commonPrefixes) {
            this.commonPrefixes(Arrays.asList(commonPrefixes));
        }

        public final String getEncodingType() {
            return this.encodingType;
        }

        @Override
        public final Builder encodingType(String encodingType) {
            this.encodingType = encodingType;
            return this;
        }

        @Override
        public final Builder encodingType(EncodingType encodingType) {
            this.encodingType(encodingType.toString());
            return this;
        }

        public final void setEncodingType(String encodingType) {
            this.encodingType = encodingType;
        }

        public final void setEncodingType(EncodingType encodingType) {
            this.encodingType(encodingType.toString());
        }

        public final Integer getKeyCount() {
            return this.keyCount;
        }

        @Override
        public final Builder keyCount(Integer keyCount) {
            this.keyCount = keyCount;
            return this;
        }

        public final void setKeyCount(Integer keyCount) {
            this.keyCount = keyCount;
        }

        public final String getContinuationToken() {
            return this.continuationToken;
        }

        @Override
        public final Builder continuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
            return this;
        }

        public final void setContinuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
        }

        public final String getNextContinuationToken() {
            return this.nextContinuationToken;
        }

        @Override
        public final Builder nextContinuationToken(String nextContinuationToken) {
            this.nextContinuationToken = nextContinuationToken;
            return this;
        }

        public final void setNextContinuationToken(String nextContinuationToken) {
            this.nextContinuationToken = nextContinuationToken;
        }

        public final String getStartAfter() {
            return this.startAfter;
        }

        @Override
        public final Builder startAfter(String startAfter) {
            this.startAfter = startAfter;
            return this;
        }

        public final void setStartAfter(String startAfter) {
            this.startAfter = startAfter;
        }

        public ListObjectsV2Response build() {
            return new ListObjectsV2Response(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListObjectsV2Response> {
        public Builder isTruncated(Boolean var1);

        public Builder contents(Collection<S3Object> var1);

        public Builder contents(S3Object ... var1);

        public Builder name(String var1);

        public Builder prefix(String var1);

        public Builder delimiter(String var1);

        public Builder maxKeys(Integer var1);

        public Builder commonPrefixes(Collection<CommonPrefix> var1);

        public Builder commonPrefixes(CommonPrefix ... var1);

        public Builder encodingType(String var1);

        public Builder encodingType(EncodingType var1);

        public Builder keyCount(Integer var1);

        public Builder continuationToken(String var1);

        public Builder nextContinuationToken(String var1);

        public Builder startAfter(String var1);
    }
}

