/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.s3.model.Rule;
import software.amazon.awssdk.services.s3.model.RulesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class LifecycleConfiguration
implements ToCopyableBuilder<Builder, LifecycleConfiguration> {
    private final List<Rule> rules;

    private LifecycleConfiguration(BuilderImpl builder) {
        this.rules = builder.rules;
    }

    public List<Rule> rules() {
        return this.rules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.rules() == null ? 0 : this.rules().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifecycleConfiguration)) {
            return false;
        }
        LifecycleConfiguration other = (LifecycleConfiguration)obj;
        if (other.rules() == null ^ this.rules() == null) {
            return false;
        }
        return other.rules() == null || other.rules().equals(this.rules());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.rules() != null) {
            sb.append("Rules: ").append(this.rules()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Rule> rules;

        private BuilderImpl() {
        }

        private BuilderImpl(LifecycleConfiguration model) {
            this.setRules(model.rules);
        }

        public final Collection<Rule> getRules() {
            return this.rules;
        }

        @Override
        public final Builder rules(Collection<Rule> rules) {
            this.rules = RulesCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Rule ... rules) {
            this.rules(Arrays.asList(rules));
            return this;
        }

        public final void setRules(Collection<Rule> rules) {
            this.rules = RulesCopier.copy(rules);
        }

        @SafeVarargs
        public final void setRules(Rule ... rules) {
            this.rules(Arrays.asList(rules));
        }

        public LifecycleConfiguration build() {
            return new LifecycleConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LifecycleConfiguration> {
        public Builder rules(Collection<Rule> var1);

        public Builder rules(Rule ... var1);
    }
}

