/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.s3.model.CloudFunctionConfiguration;
import software.amazon.awssdk.services.s3.model.QueueConfigurationDeprecated;
import software.amazon.awssdk.services.s3.model.TopicConfigurationDeprecated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetBucketNotificationResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetBucketNotificationResponse> {
    private final TopicConfigurationDeprecated topicConfiguration;
    private final QueueConfigurationDeprecated queueConfiguration;
    private final CloudFunctionConfiguration cloudFunctionConfiguration;

    private GetBucketNotificationResponse(BuilderImpl builder) {
        this.topicConfiguration = builder.topicConfiguration;
        this.queueConfiguration = builder.queueConfiguration;
        this.cloudFunctionConfiguration = builder.cloudFunctionConfiguration;
    }

    public TopicConfigurationDeprecated topicConfiguration() {
        return this.topicConfiguration;
    }

    public QueueConfigurationDeprecated queueConfiguration() {
        return this.queueConfiguration;
    }

    public CloudFunctionConfiguration cloudFunctionConfiguration() {
        return this.cloudFunctionConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.topicConfiguration() == null ? 0 : this.topicConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.queueConfiguration() == null ? 0 : this.queueConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.cloudFunctionConfiguration() == null ? 0 : this.cloudFunctionConfiguration().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBucketNotificationResponse)) {
            return false;
        }
        GetBucketNotificationResponse other = (GetBucketNotificationResponse)((Object)obj);
        if (other.topicConfiguration() == null ^ this.topicConfiguration() == null) {
            return false;
        }
        if (other.topicConfiguration() != null && !other.topicConfiguration().equals(this.topicConfiguration())) {
            return false;
        }
        if (other.queueConfiguration() == null ^ this.queueConfiguration() == null) {
            return false;
        }
        if (other.queueConfiguration() != null && !other.queueConfiguration().equals(this.queueConfiguration())) {
            return false;
        }
        if (other.cloudFunctionConfiguration() == null ^ this.cloudFunctionConfiguration() == null) {
            return false;
        }
        return other.cloudFunctionConfiguration() == null || other.cloudFunctionConfiguration().equals(this.cloudFunctionConfiguration());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.topicConfiguration() != null) {
            sb.append("TopicConfiguration: ").append(this.topicConfiguration()).append(",");
        }
        if (this.queueConfiguration() != null) {
            sb.append("QueueConfiguration: ").append(this.queueConfiguration()).append(",");
        }
        if (this.cloudFunctionConfiguration() != null) {
            sb.append("CloudFunctionConfiguration: ").append(this.cloudFunctionConfiguration()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private TopicConfigurationDeprecated topicConfiguration;
        private QueueConfigurationDeprecated queueConfiguration;
        private CloudFunctionConfiguration cloudFunctionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBucketNotificationResponse model) {
            this.setTopicConfiguration(model.topicConfiguration);
            this.setQueueConfiguration(model.queueConfiguration);
            this.setCloudFunctionConfiguration(model.cloudFunctionConfiguration);
        }

        public final TopicConfigurationDeprecated getTopicConfiguration() {
            return this.topicConfiguration;
        }

        @Override
        public final Builder topicConfiguration(TopicConfigurationDeprecated topicConfiguration) {
            this.topicConfiguration = topicConfiguration;
            return this;
        }

        public final void setTopicConfiguration(TopicConfigurationDeprecated topicConfiguration) {
            this.topicConfiguration = topicConfiguration;
        }

        public final QueueConfigurationDeprecated getQueueConfiguration() {
            return this.queueConfiguration;
        }

        @Override
        public final Builder queueConfiguration(QueueConfigurationDeprecated queueConfiguration) {
            this.queueConfiguration = queueConfiguration;
            return this;
        }

        public final void setQueueConfiguration(QueueConfigurationDeprecated queueConfiguration) {
            this.queueConfiguration = queueConfiguration;
        }

        public final CloudFunctionConfiguration getCloudFunctionConfiguration() {
            return this.cloudFunctionConfiguration;
        }

        @Override
        public final Builder cloudFunctionConfiguration(CloudFunctionConfiguration cloudFunctionConfiguration) {
            this.cloudFunctionConfiguration = cloudFunctionConfiguration;
            return this;
        }

        public final void setCloudFunctionConfiguration(CloudFunctionConfiguration cloudFunctionConfiguration) {
            this.cloudFunctionConfiguration = cloudFunctionConfiguration;
        }

        public GetBucketNotificationResponse build() {
            return new GetBucketNotificationResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetBucketNotificationResponse> {
        public Builder topicConfiguration(TopicConfigurationDeprecated var1);

        public Builder queueConfiguration(QueueConfigurationDeprecated var1);

        public Builder cloudFunctionConfiguration(CloudFunctionConfiguration var1);
    }
}

