/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.s3.model.BucketCannedACL;
import software.amazon.awssdk.services.s3.model.CreateBucketConfiguration;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateBucketRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateBucketRequest> {
    private final String acl;
    private final String bucket;
    private final CreateBucketConfiguration createBucketConfiguration;
    private final String grantFullControl;
    private final String grantRead;
    private final String grantReadACP;
    private final String grantWrite;
    private final String grantWriteACP;

    private CreateBucketRequest(BuilderImpl builder) {
        this.acl = builder.acl;
        this.bucket = builder.bucket;
        this.createBucketConfiguration = builder.createBucketConfiguration;
        this.grantFullControl = builder.grantFullControl;
        this.grantRead = builder.grantRead;
        this.grantReadACP = builder.grantReadACP;
        this.grantWrite = builder.grantWrite;
        this.grantWriteACP = builder.grantWriteACP;
    }

    public String acl() {
        return this.acl;
    }

    public String bucket() {
        return this.bucket;
    }

    public CreateBucketConfiguration createBucketConfiguration() {
        return this.createBucketConfiguration;
    }

    public String grantFullControl() {
        return this.grantFullControl;
    }

    public String grantRead() {
        return this.grantRead;
    }

    public String grantReadACP() {
        return this.grantReadACP;
    }

    public String grantWrite() {
        return this.grantWrite;
    }

    public String grantWriteACP() {
        return this.grantWriteACP;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.acl() == null ? 0 : this.acl().hashCode());
        hashCode = 31 * hashCode + (this.bucket() == null ? 0 : this.bucket().hashCode());
        hashCode = 31 * hashCode + (this.createBucketConfiguration() == null ? 0 : this.createBucketConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.grantFullControl() == null ? 0 : this.grantFullControl().hashCode());
        hashCode = 31 * hashCode + (this.grantRead() == null ? 0 : this.grantRead().hashCode());
        hashCode = 31 * hashCode + (this.grantReadACP() == null ? 0 : this.grantReadACP().hashCode());
        hashCode = 31 * hashCode + (this.grantWrite() == null ? 0 : this.grantWrite().hashCode());
        hashCode = 31 * hashCode + (this.grantWriteACP() == null ? 0 : this.grantWriteACP().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBucketRequest)) {
            return false;
        }
        CreateBucketRequest other = (CreateBucketRequest)((Object)obj);
        if (other.acl() == null ^ this.acl() == null) {
            return false;
        }
        if (other.acl() != null && !other.acl().equals(this.acl())) {
            return false;
        }
        if (other.bucket() == null ^ this.bucket() == null) {
            return false;
        }
        if (other.bucket() != null && !other.bucket().equals(this.bucket())) {
            return false;
        }
        if (other.createBucketConfiguration() == null ^ this.createBucketConfiguration() == null) {
            return false;
        }
        if (other.createBucketConfiguration() != null && !other.createBucketConfiguration().equals(this.createBucketConfiguration())) {
            return false;
        }
        if (other.grantFullControl() == null ^ this.grantFullControl() == null) {
            return false;
        }
        if (other.grantFullControl() != null && !other.grantFullControl().equals(this.grantFullControl())) {
            return false;
        }
        if (other.grantRead() == null ^ this.grantRead() == null) {
            return false;
        }
        if (other.grantRead() != null && !other.grantRead().equals(this.grantRead())) {
            return false;
        }
        if (other.grantReadACP() == null ^ this.grantReadACP() == null) {
            return false;
        }
        if (other.grantReadACP() != null && !other.grantReadACP().equals(this.grantReadACP())) {
            return false;
        }
        if (other.grantWrite() == null ^ this.grantWrite() == null) {
            return false;
        }
        if (other.grantWrite() != null && !other.grantWrite().equals(this.grantWrite())) {
            return false;
        }
        if (other.grantWriteACP() == null ^ this.grantWriteACP() == null) {
            return false;
        }
        return other.grantWriteACP() == null || other.grantWriteACP().equals(this.grantWriteACP());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.acl() != null) {
            sb.append("ACL: ").append(this.acl()).append(",");
        }
        if (this.bucket() != null) {
            sb.append("Bucket: ").append(this.bucket()).append(",");
        }
        if (this.createBucketConfiguration() != null) {
            sb.append("CreateBucketConfiguration: ").append(this.createBucketConfiguration()).append(",");
        }
        if (this.grantFullControl() != null) {
            sb.append("GrantFullControl: ").append(this.grantFullControl()).append(",");
        }
        if (this.grantRead() != null) {
            sb.append("GrantRead: ").append(this.grantRead()).append(",");
        }
        if (this.grantReadACP() != null) {
            sb.append("GrantReadACP: ").append(this.grantReadACP()).append(",");
        }
        if (this.grantWrite() != null) {
            sb.append("GrantWrite: ").append(this.grantWrite()).append(",");
        }
        if (this.grantWriteACP() != null) {
            sb.append("GrantWriteACP: ").append(this.grantWriteACP()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String acl;
        private String bucket;
        private CreateBucketConfiguration createBucketConfiguration;
        private String grantFullControl;
        private String grantRead;
        private String grantReadACP;
        private String grantWrite;
        private String grantWriteACP;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBucketRequest model) {
            this.setACL(model.acl);
            this.setBucket(model.bucket);
            this.setCreateBucketConfiguration(model.createBucketConfiguration);
            this.setGrantFullControl(model.grantFullControl);
            this.setGrantRead(model.grantRead);
            this.setGrantReadACP(model.grantReadACP);
            this.setGrantWrite(model.grantWrite);
            this.setGrantWriteACP(model.grantWriteACP);
        }

        public final String getACL() {
            return this.acl;
        }

        @Override
        public final Builder acl(String acl) {
            this.acl = acl;
            return this;
        }

        @Override
        public final Builder acl(BucketCannedACL acl) {
            this.acl(acl.toString());
            return this;
        }

        public final void setACL(String acl) {
            this.acl = acl;
        }

        public final void setACL(BucketCannedACL acl) {
            this.acl(acl.toString());
        }

        public final String getBucket() {
            return this.bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final CreateBucketConfiguration getCreateBucketConfiguration() {
            return this.createBucketConfiguration;
        }

        @Override
        public final Builder createBucketConfiguration(CreateBucketConfiguration createBucketConfiguration) {
            this.createBucketConfiguration = createBucketConfiguration;
            return this;
        }

        public final void setCreateBucketConfiguration(CreateBucketConfiguration createBucketConfiguration) {
            this.createBucketConfiguration = createBucketConfiguration;
        }

        public final String getGrantFullControl() {
            return this.grantFullControl;
        }

        @Override
        public final Builder grantFullControl(String grantFullControl) {
            this.grantFullControl = grantFullControl;
            return this;
        }

        public final void setGrantFullControl(String grantFullControl) {
            this.grantFullControl = grantFullControl;
        }

        public final String getGrantRead() {
            return this.grantRead;
        }

        @Override
        public final Builder grantRead(String grantRead) {
            this.grantRead = grantRead;
            return this;
        }

        public final void setGrantRead(String grantRead) {
            this.grantRead = grantRead;
        }

        public final String getGrantReadACP() {
            return this.grantReadACP;
        }

        @Override
        public final Builder grantReadACP(String grantReadACP) {
            this.grantReadACP = grantReadACP;
            return this;
        }

        public final void setGrantReadACP(String grantReadACP) {
            this.grantReadACP = grantReadACP;
        }

        public final String getGrantWrite() {
            return this.grantWrite;
        }

        @Override
        public final Builder grantWrite(String grantWrite) {
            this.grantWrite = grantWrite;
            return this;
        }

        public final void setGrantWrite(String grantWrite) {
            this.grantWrite = grantWrite;
        }

        public final String getGrantWriteACP() {
            return this.grantWriteACP;
        }

        @Override
        public final Builder grantWriteACP(String grantWriteACP) {
            this.grantWriteACP = grantWriteACP;
            return this;
        }

        public final void setGrantWriteACP(String grantWriteACP) {
            this.grantWriteACP = grantWriteACP;
        }

        public CreateBucketRequest build() {
            return new CreateBucketRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateBucketRequest> {
        public Builder acl(String var1);

        public Builder acl(BucketCannedACL var1);

        public Builder bucket(String var1);

        public Builder createBucketConfiguration(CreateBucketConfiguration var1);

        public Builder grantFullControl(String var1);

        public Builder grantRead(String var1);

        public Builder grantReadACP(String var1);

        public Builder grantWrite(String var1);

        public Builder grantWriteACP(String var1);
    }
}

