/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.s3.model.Grant;
import software.amazon.awssdk.services.s3.model.GrantsCopier;
import software.amazon.awssdk.services.s3.model.Owner;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AccessControlPolicy
implements ToCopyableBuilder<Builder, AccessControlPolicy> {
    private final List<Grant> grants;
    private final Owner owner;

    private AccessControlPolicy(BuilderImpl builder) {
        this.grants = builder.grants;
        this.owner = builder.owner;
    }

    public List<Grant> grants() {
        return this.grants;
    }

    public Owner owner() {
        return this.owner;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.grants() == null ? 0 : this.grants().hashCode());
        hashCode = 31 * hashCode + (this.owner() == null ? 0 : this.owner().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessControlPolicy)) {
            return false;
        }
        AccessControlPolicy other = (AccessControlPolicy)obj;
        if (other.grants() == null ^ this.grants() == null) {
            return false;
        }
        if (other.grants() != null && !other.grants().equals(this.grants())) {
            return false;
        }
        if (other.owner() == null ^ this.owner() == null) {
            return false;
        }
        return other.owner() == null || other.owner().equals(this.owner());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.grants() != null) {
            sb.append("Grants: ").append(this.grants()).append(",");
        }
        if (this.owner() != null) {
            sb.append("Owner: ").append(this.owner()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Grant> grants;
        private Owner owner;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessControlPolicy model) {
            this.setGrants(model.grants);
            this.setOwner(model.owner);
        }

        public final Collection<Grant> getGrants() {
            return this.grants;
        }

        @Override
        public final Builder grants(Collection<Grant> grants) {
            this.grants = GrantsCopier.copy(grants);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grants(Grant ... grants) {
            this.grants(Arrays.asList(grants));
            return this;
        }

        public final void setGrants(Collection<Grant> grants) {
            this.grants = GrantsCopier.copy(grants);
        }

        @SafeVarargs
        public final void setGrants(Grant ... grants) {
            this.grants(Arrays.asList(grants));
        }

        public final Owner getOwner() {
            return this.owner;
        }

        @Override
        public final Builder owner(Owner owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(Owner owner) {
            this.owner = owner;
        }

        public AccessControlPolicy build() {
            return new AccessControlPolicy(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AccessControlPolicy> {
        public Builder grants(Collection<Grant> var1);

        public Builder grants(Grant ... var1);

        public Builder owner(Owner var1);
    }
}

