/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.transform;

import static software.amazon.awssdk.util.StringUtils.UTF8;

import java.io.StringWriter;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.services.s3.model.*;
import software.amazon.awssdk.runtime.transform.Marshaller;

import software.amazon.awssdk.util.StringInputStream;
import software.amazon.awssdk.util.StringUtils;

import software.amazon.awssdk.util.Md5Utils;
import software.amazon.awssdk.util.XmlWriter;

/**
 * PutBucketLoggingRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class PutBucketLoggingRequestMarshaller implements Marshaller<Request<PutBucketLoggingRequest>, PutBucketLoggingRequest> {

    public Request<PutBucketLoggingRequest> marshall(PutBucketLoggingRequest putBucketLoggingRequest) {

        if (putBucketLoggingRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<PutBucketLoggingRequest> request = new DefaultRequest<PutBucketLoggingRequest>(putBucketLoggingRequest,
                "S3Client");

        request.setHttpMethod(HttpMethodName.PUT);

        if (putBucketLoggingRequest.contentMD5() != null) {
            request.addHeader("Content-MD5", StringUtils.fromString(putBucketLoggingRequest.contentMD5()));
        }

        String uriResourcePath = "/{Bucket}?logging";

        uriResourcePath = software.amazon.awssdk.util.UriResourcePathUtils.addStaticQueryParamtersToRequest(request,
                uriResourcePath);

        uriResourcePath = software.amazon.awssdk.runtime.transform.PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket",
                putBucketLoggingRequest.bucket());
        request.setResourcePath(uriResourcePath);

        try {
            StringWriter stringWriter = null;
            BucketLoggingStatus bucketLoggingStatus = putBucketLoggingRequest.bucketLoggingStatus();
            if (bucketLoggingStatus != null) {
                stringWriter = new StringWriter();
                XmlWriter xmlWriter = new XmlWriter(stringWriter, "http://s3.amazonaws.com/doc/2006-03-01/");
                xmlWriter.startElement("BucketLoggingStatus");

                LoggingEnabled loggingEnabled = bucketLoggingStatus.loggingEnabled();
                if (loggingEnabled != null) {
                    xmlWriter.startElement("LoggingEnabled");

                    if (loggingEnabled.targetBucket() != null) {
                        xmlWriter.startElement("TargetBucket").value(loggingEnabled.targetBucket()).endElement();
                    }

                    java.util.List<TargetGrant> loggingEnabledTargetGrantsList = loggingEnabled.targetGrants();
                    if (loggingEnabledTargetGrantsList != null) {
                        xmlWriter.startElement("TargetGrants");

                        for (TargetGrant loggingEnabledTargetGrantsListValue : loggingEnabledTargetGrantsList) {
                            xmlWriter.startElement("Grant");

                            Grantee grantee = loggingEnabledTargetGrantsListValue.grantee();
                            if (grantee != null) {
                                xmlWriter.startElement("Grantee");

                                if (grantee.displayName() != null) {
                                    xmlWriter.startElement("DisplayName").value(grantee.displayName()).endElement();
                                }

                                if (grantee.emailAddress() != null) {
                                    xmlWriter.startElement("EmailAddress").value(grantee.emailAddress()).endElement();
                                }

                                if (grantee.id() != null) {
                                    xmlWriter.startElement("ID").value(grantee.id()).endElement();
                                }

                                if (grantee.type() != null) {
                                    xmlWriter.startElement("xsi:type").value(grantee.type()).endElement();
                                }

                                if (grantee.uri() != null) {
                                    xmlWriter.startElement("URI").value(grantee.uri()).endElement();
                                }
                                xmlWriter.endElement();
                            }

                            if (loggingEnabledTargetGrantsListValue.permission() != null) {
                                xmlWriter.startElement("Permission").value(loggingEnabledTargetGrantsListValue.permission())
                                        .endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }

                    if (loggingEnabled.targetPrefix() != null) {
                        xmlWriter.startElement("TargetPrefix").value(loggingEnabled.targetPrefix()).endElement();
                    }
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }

            if (stringWriter != null) {
                if (!request.getHeaders().containsKey("Content-MD5")) {
                    request.addHeader("Content-MD5", Md5Utils.md5AsBase64(stringWriter.getBuffer().toString().getBytes(UTF8)));
                }
                request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
                request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(UTF8).length));
            }
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        } catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }

        return request;
    }

}