/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.services.s3.model.*;
import software.amazon.awssdk.runtime.transform.Marshaller;

import software.amazon.awssdk.util.StringUtils;

/**
 * GetObjectTaggingRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class GetObjectTaggingRequestMarshaller implements Marshaller<Request<GetObjectTaggingRequest>, GetObjectTaggingRequest> {

    public Request<GetObjectTaggingRequest> marshall(GetObjectTaggingRequest getObjectTaggingRequest) {

        if (getObjectTaggingRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<GetObjectTaggingRequest> request = new DefaultRequest<GetObjectTaggingRequest>(getObjectTaggingRequest,
                "S3Client");

        request.setHttpMethod(HttpMethodName.GET);

        String uriResourcePath = "/{Bucket}/{Key+}?tagging";

        uriResourcePath = software.amazon.awssdk.util.UriResourcePathUtils.addStaticQueryParamtersToRequest(request,
                uriResourcePath);

        uriResourcePath = software.amazon.awssdk.runtime.transform.PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket",
                getObjectTaggingRequest.bucket());
        uriResourcePath = software.amazon.awssdk.runtime.transform.PathMarshallers.GREEDY.marshall(uriResourcePath, "Key",
                getObjectTaggingRequest.key());
        request.setResourcePath(uriResourcePath);

        if (getObjectTaggingRequest.versionId() != null) {
            request.addParameter("versionId", StringUtils.fromString(getObjectTaggingRequest.versionId()));
        }

        return request;
    }

}