/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class IndexDocument implements ToCopyableBuilder<IndexDocument.Builder, IndexDocument> {
    private final String suffix;

    private IndexDocument(BuilderImpl builder) {
        this.suffix = builder.suffix;
    }

    /**
     * A suffix that is appended to a request that is for a directory on the website endpoint (e.g. if the suffix is
     * index.html and you make a request to samplebucket/images/ the data that is returned will be for the object with
     * the key name images/index.html) The suffix must not be empty and must not include a slash character.
     * 
     * @return A suffix that is appended to a request that is for a directory on the website endpoint (e.g. if the
     *         suffix is index.html and you make a request to samplebucket/images/ the data that is returned will be for
     *         the object with the key name images/index.html) The suffix must not be empty and must not include a slash
     *         character.
     */
    public String suffix() {
        return suffix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((suffix() == null) ? 0 : suffix().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IndexDocument)) {
            return false;
        }
        IndexDocument other = (IndexDocument) obj;
        if (other.suffix() == null ^ this.suffix() == null) {
            return false;
        }
        if (other.suffix() != null && !other.suffix().equals(this.suffix())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (suffix() != null) {
            sb.append("Suffix: ").append(suffix()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, IndexDocument> {
        /**
         * A suffix that is appended to a request that is for a directory on the website endpoint (e.g. if the suffix is
         * index.html and you make a request to samplebucket/images/ the data that is returned will be for the object
         * with the key name images/index.html) The suffix must not be empty and must not include a slash character.
         * 
         * @param suffix
         *        A suffix that is appended to a request that is for a directory on the website endpoint (e.g. if the
         *        suffix is index.html and you make a request to samplebucket/images/ the data that is returned will be
         *        for the object with the key name images/index.html) The suffix must not be empty and must not include
         *        a slash character.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suffix(String suffix);
    }

    private static final class BuilderImpl implements Builder {
        private String suffix;

        private BuilderImpl() {
        }

        private BuilderImpl(IndexDocument model) {
            setSuffix(model.suffix);
        }

        public final String getSuffix() {
            return suffix;
        }

        @Override
        public final Builder suffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        public final void setSuffix(String suffix) {
            this.suffix = suffix;
        }

        @Override
        public IndexDocument build() {
            return new IndexDocument(this);
        }
    }
}
