/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GlacierJobParameters implements ToCopyableBuilder<GlacierJobParameters.Builder, GlacierJobParameters> {
    private final String tier;

    private GlacierJobParameters(BuilderImpl builder) {
        this.tier = builder.tier;
    }

    /**
     * Glacier retrieval tier at which the restore will be processed.
     * 
     * @return Glacier retrieval tier at which the restore will be processed.
     * @see Tier
     */
    public String tier() {
        return tier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((tier() == null) ? 0 : tier().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlacierJobParameters)) {
            return false;
        }
        GlacierJobParameters other = (GlacierJobParameters) obj;
        if (other.tier() == null ^ this.tier() == null) {
            return false;
        }
        if (other.tier() != null && !other.tier().equals(this.tier())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (tier() != null) {
            sb.append("Tier: ").append(tier()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GlacierJobParameters> {
        /**
         * Glacier retrieval tier at which the restore will be processed.
         * 
         * @param tier
         *        Glacier retrieval tier at which the restore will be processed.
         * @see Tier
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tier
         */
        Builder tier(String tier);

        /**
         * Glacier retrieval tier at which the restore will be processed.
         * 
         * @param tier
         *        Glacier retrieval tier at which the restore will be processed.
         * @see Tier
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tier
         */
        Builder tier(Tier tier);
    }

    private static final class BuilderImpl implements Builder {
        private String tier;

        private BuilderImpl() {
        }

        private BuilderImpl(GlacierJobParameters model) {
            setTier(model.tier);
        }

        public final String getTier() {
            return tier;
        }

        @Override
        public final Builder tier(String tier) {
            this.tier = tier;
            return this;
        }

        @Override
        public final Builder tier(Tier tier) {
            this.tier(tier.toString());
            return this;
        }

        public final void setTier(String tier) {
            this.tier = tier;
        }

        public final void setTier(Tier tier) {
            this.tier(tier.toString());
        }

        @Override
        public GlacierJobParameters build() {
            return new GlacierJobParameters(this);
        }
    }
}
