/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteObjectTaggingResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DeleteObjectTaggingResponse.Builder, DeleteObjectTaggingResponse> {
    private final String versionId;

    private DeleteObjectTaggingResponse(BuilderImpl builder) {
        this.versionId = builder.versionId;
    }

    /**
     * The versionId of the object the tag-set was removed from.
     * 
     * @return The versionId of the object the tag-set was removed from.
     */
    public String versionId() {
        return versionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((versionId() == null) ? 0 : versionId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteObjectTaggingResponse)) {
            return false;
        }
        DeleteObjectTaggingResponse other = (DeleteObjectTaggingResponse) obj;
        if (other.versionId() == null ^ this.versionId() == null) {
            return false;
        }
        if (other.versionId() != null && !other.versionId().equals(this.versionId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (versionId() != null) {
            sb.append("VersionId: ").append(versionId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteObjectTaggingResponse> {
        /**
         * The versionId of the object the tag-set was removed from.
         * 
         * @param versionId
         *        The versionId of the object the tag-set was removed from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionId(String versionId);
    }

    private static final class BuilderImpl implements Builder {
        private String versionId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteObjectTaggingResponse model) {
            setVersionId(model.versionId);
        }

        public final String getVersionId() {
            return versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        @Override
        public DeleteObjectTaggingResponse build() {
            return new DeleteObjectTaggingResponse(this);
        }
    }
}
