/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CompletedPart implements ToCopyableBuilder<CompletedPart.Builder, CompletedPart> {
    private final String eTag;

    private final Integer partNumber;

    private CompletedPart(BuilderImpl builder) {
        this.eTag = builder.eTag;
        this.partNumber = builder.partNumber;
    }

    /**
     * Entity tag returned when the part was uploaded.
     * 
     * @return Entity tag returned when the part was uploaded.
     */
    public String eTag() {
        return eTag;
    }

    /**
     * Part number that identifies the part. This is a positive integer between 1 and 10,000.
     * 
     * @return Part number that identifies the part. This is a positive integer between 1 and 10,000.
     */
    public Integer partNumber() {
        return partNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((eTag() == null) ? 0 : eTag().hashCode());
        hashCode = 31 * hashCode + ((partNumber() == null) ? 0 : partNumber().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompletedPart)) {
            return false;
        }
        CompletedPart other = (CompletedPart) obj;
        if (other.eTag() == null ^ this.eTag() == null) {
            return false;
        }
        if (other.eTag() != null && !other.eTag().equals(this.eTag())) {
            return false;
        }
        if (other.partNumber() == null ^ this.partNumber() == null) {
            return false;
        }
        if (other.partNumber() != null && !other.partNumber().equals(this.partNumber())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (eTag() != null) {
            sb.append("ETag: ").append(eTag()).append(",");
        }
        if (partNumber() != null) {
            sb.append("PartNumber: ").append(partNumber()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CompletedPart> {
        /**
         * Entity tag returned when the part was uploaded.
         * 
         * @param eTag
         *        Entity tag returned when the part was uploaded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eTag(String eTag);

        /**
         * Part number that identifies the part. This is a positive integer between 1 and 10,000.
         * 
         * @param partNumber
         *        Part number that identifies the part. This is a positive integer between 1 and 10,000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partNumber(Integer partNumber);
    }

    private static final class BuilderImpl implements Builder {
        private String eTag;

        private Integer partNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(CompletedPart model) {
            setETag(model.eTag);
            setPartNumber(model.partNumber);
        }

        public final String getETag() {
            return eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        public final Integer getPartNumber() {
            return partNumber;
        }

        @Override
        public final Builder partNumber(Integer partNumber) {
            this.partNumber = partNumber;
            return this;
        }

        public final void setPartNumber(Integer partNumber) {
            this.partNumber = partNumber;
        }

        @Override
        public CompletedPart build() {
            return new CompletedPart(this);
        }
    }
}
