/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CompletedMultipartUpload implements ToCopyableBuilder<CompletedMultipartUpload.Builder, CompletedMultipartUpload> {
    private final List<CompletedPart> parts;

    private CompletedMultipartUpload(BuilderImpl builder) {
        this.parts = builder.parts;
    }

    /**
     * Returns the value of the Parts property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the Parts property for this object.
     */
    public List<CompletedPart> parts() {
        return parts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((parts() == null) ? 0 : parts().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompletedMultipartUpload)) {
            return false;
        }
        CompletedMultipartUpload other = (CompletedMultipartUpload) obj;
        if (other.parts() == null ^ this.parts() == null) {
            return false;
        }
        if (other.parts() != null && !other.parts().equals(this.parts())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (parts() != null) {
            sb.append("Parts: ").append(parts()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CompletedMultipartUpload> {
        /**
         * Sets the value of the Parts property for this object.
         *
         * @param parts
         *        The new value for the Parts property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parts(Collection<CompletedPart> parts);

        /**
         * Sets the value of the Parts property for this object.
         *
         * @param parts
         *        The new value for the Parts property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parts(CompletedPart... parts);
    }

    private static final class BuilderImpl implements Builder {
        private List<CompletedPart> parts;

        private BuilderImpl() {
        }

        private BuilderImpl(CompletedMultipartUpload model) {
            setParts(model.parts);
        }

        public final Collection<CompletedPart> getParts() {
            return parts;
        }

        @Override
        public final Builder parts(Collection<CompletedPart> parts) {
            this.parts = CompletedPartListCopier.copy(parts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parts(CompletedPart... parts) {
            parts(Arrays.asList(parts));
            return this;
        }

        public final void setParts(Collection<CompletedPart> parts) {
            this.parts = CompletedPartListCopier.copy(parts);
        }

        @SafeVarargs
        public final void setParts(CompletedPart... parts) {
            parts(Arrays.asList(parts));
        }

        @Override
        public CompletedMultipartUpload build() {
            return new CompletedMultipartUpload(this);
        }
    }
}
