/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.s3.model.Event;
import software.amazon.awssdk.services.s3.model.EventListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QueueConfigurationDeprecated
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QueueConfigurationDeprecated> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(QueueConfigurationDeprecated.getter(QueueConfigurationDeprecated::id)).setter(QueueConfigurationDeprecated.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").unmarshallLocationName("Id").build()}).build();
    private static final SdkField<String> EVENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(QueueConfigurationDeprecated.getter(QueueConfigurationDeprecated::eventAsString)).setter(QueueConfigurationDeprecated.setter(Builder::event)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Event").unmarshallLocationName("Event").build()}).build();
    private static final SdkField<List<String>> EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(QueueConfigurationDeprecated.getter(QueueConfigurationDeprecated::eventsAsStrings)).setter(QueueConfigurationDeprecated.setter(Builder::eventsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Events").unmarshallLocationName("Event").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).isFlattened(true).build()}).build();
    private static final SdkField<String> QUEUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(QueueConfigurationDeprecated.getter(QueueConfigurationDeprecated::queue)).setter(QueueConfigurationDeprecated.setter(Builder::queue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Queue").unmarshallLocationName("Queue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, EVENT_FIELD, EVENTS_FIELD, QUEUE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String event;
    private final List<String> events;
    private final String queue;

    private QueueConfigurationDeprecated(BuilderImpl builder) {
        this.id = builder.id;
        this.event = builder.event;
        this.events = builder.events;
        this.queue = builder.queue;
    }

    public String id() {
        return this.id;
    }

    public Event event() {
        return Event.fromValue(this.event);
    }

    public String eventAsString() {
        return this.event;
    }

    public List<Event> events() {
        return TypeConverter.convert(this.events, Event::fromValue);
    }

    public List<String> eventsAsStrings() {
        return this.events;
    }

    public String queue() {
        return this.queue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventsAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.queue());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueueConfigurationDeprecated)) {
            return false;
        }
        QueueConfigurationDeprecated other = (QueueConfigurationDeprecated)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.eventAsString(), other.eventAsString()) && Objects.equals(this.eventsAsStrings(), other.eventsAsStrings()) && Objects.equals(this.queue(), other.queue());
    }

    public String toString() {
        return ToString.builder((String)"QueueConfigurationDeprecated").add("Id", (Object)this.id()).add("Event", (Object)this.eventAsString()).add("Events", this.eventsAsStrings()).add("Queue", (Object)this.queue()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Event": {
                return Optional.ofNullable(clazz.cast(this.eventAsString()));
            }
            case "Events": {
                return Optional.ofNullable(clazz.cast(this.eventsAsStrings()));
            }
            case "Queue": {
                return Optional.ofNullable(clazz.cast(this.queue()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueueConfigurationDeprecated, T> g) {
        return obj -> g.apply((QueueConfigurationDeprecated)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String event;
        private List<String> events = DefaultSdkAutoConstructList.getInstance();
        private String queue;

        private BuilderImpl() {
        }

        private BuilderImpl(QueueConfigurationDeprecated model) {
            this.id(model.id);
            this.event(model.event);
            this.eventsWithStrings(model.events);
            this.queue(model.queue);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getEvent() {
            return this.event;
        }

        @Override
        public final Builder event(String event) {
            this.event = event;
            return this;
        }

        @Override
        public final Builder event(Event event) {
            this.event(event.toString());
            return this;
        }

        public final void setEvent(String event) {
            this.event = event;
        }

        public final Collection<String> getEvents() {
            return this.events;
        }

        @Override
        public final Builder eventsWithStrings(Collection<String> events) {
            this.events = EventListCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventsWithStrings(String ... events) {
            this.eventsWithStrings(Arrays.asList(events));
            return this;
        }

        @Override
        public final Builder events(Collection<Event> events) {
            this.events = EventListCopier.copyEnumToString(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(Event ... events) {
            this.events(Arrays.asList(events));
            return this;
        }

        public final void setEvents(Collection<String> events) {
            this.events = EventListCopier.copy(events);
        }

        public final String getQueue() {
            return this.queue;
        }

        @Override
        public final Builder queue(String queue) {
            this.queue = queue;
            return this;
        }

        public final void setQueue(String queue) {
            this.queue = queue;
        }

        public QueueConfigurationDeprecated build() {
            return new QueueConfigurationDeprecated(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QueueConfigurationDeprecated> {
        public Builder id(String var1);

        public Builder event(String var1);

        public Builder event(Event var1);

        public Builder eventsWithStrings(Collection<String> var1);

        public Builder eventsWithStrings(String ... var1);

        public Builder events(Collection<Event> var1);

        public Builder events(Event ... var1);

        public Builder queue(String var1);
    }
}

