/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.core.util.UriResourcePathUtils;
import software.amazon.awssdk.core.util.xml.XmlWriter;
import software.amazon.awssdk.services.s3.model.Destination;
import software.amazon.awssdk.services.s3.model.PutBucketReplicationRequest;
import software.amazon.awssdk.services.s3.model.ReplicationConfiguration;
import software.amazon.awssdk.services.s3.model.ReplicationRule;
import software.amazon.awssdk.utils.Md5Utils;
import software.amazon.awssdk.utils.StringInputStream;

public class PutBucketReplicationRequestMarshaller
implements Marshaller<Request<PutBucketReplicationRequest>, PutBucketReplicationRequest> {
    public Request<PutBucketReplicationRequest> marshall(PutBucketReplicationRequest putBucketReplicationRequest) {
        if (putBucketReplicationRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)putBucketReplicationRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.PUT);
        if (putBucketReplicationRequest.contentMD5() != null) {
            request.addHeader("Content-MD5", StringConversion.fromString((String)putBucketReplicationRequest.contentMD5()));
        }
        String uriResourcePath = "/{Bucket}?replication";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParametersToRequest((Request)request, (String)uriResourcePath);
        uriResourcePath = PathMarshaller.NON_GREEDY.marshall(uriResourcePath, "Bucket", putBucketReplicationRequest.bucket());
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = null;
            ReplicationConfiguration replicationConfiguration = putBucketReplicationRequest.replicationConfiguration();
            if (replicationConfiguration != null) {
                List<ReplicationRule> replicationConfigurationRulesList;
                stringWriter = new StringWriter();
                XmlWriter xmlWriter = new XmlWriter((Writer)stringWriter, "http://s3.amazonaws.com/doc/2006-03-01/");
                xmlWriter.startElement("ReplicationConfiguration");
                if (replicationConfiguration.role() != null) {
                    xmlWriter.startElement("Role").value(replicationConfiguration.role()).endElement();
                }
                if (!(replicationConfigurationRulesList = replicationConfiguration.rules()).isEmpty() || !(replicationConfigurationRulesList instanceof SdkAutoConstructList)) {
                    for (ReplicationRule replicationConfigurationRulesListValue : replicationConfigurationRulesList) {
                        Destination destination;
                        xmlWriter.startElement("Rule");
                        if (replicationConfigurationRulesListValue.id() != null) {
                            xmlWriter.startElement("ID").value(replicationConfigurationRulesListValue.id()).endElement();
                        }
                        if (replicationConfigurationRulesListValue.prefix() != null) {
                            xmlWriter.startElement("Prefix").value(replicationConfigurationRulesListValue.prefix()).endElement();
                        }
                        if (replicationConfigurationRulesListValue.statusAsString() != null) {
                            xmlWriter.startElement("Status").value(replicationConfigurationRulesListValue.statusAsString()).endElement();
                        }
                        if ((destination = replicationConfigurationRulesListValue.destination()) != null) {
                            xmlWriter.startElement("Destination");
                            if (destination.bucket() != null) {
                                xmlWriter.startElement("Bucket").value(destination.bucket()).endElement();
                            }
                            if (destination.storageClassAsString() != null) {
                                xmlWriter.startElement("StorageClass").value(destination.storageClassAsString()).endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                }
                xmlWriter.endElement();
            }
            if (stringWriter != null) {
                if (!request.getHeaders().containsKey("Content-MD5")) {
                    request.addHeader("Content-MD5", Md5Utils.md5AsBase64((byte[])stringWriter.getBuffer().toString().getBytes(StandardCharsets.UTF_8)));
                }
                request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
                request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StandardCharsets.UTF_8).length));
            }
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw SdkClientException.builder().message("Unable to marshall request to XML: " + t.getMessage()).cause(t).build();
        }
        return request;
    }
}

