/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.core.util.UriResourcePathUtils;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;

public class ListObjectsV2RequestMarshaller
implements Marshaller<Request<ListObjectsV2Request>, ListObjectsV2Request> {
    public Request<ListObjectsV2Request> marshall(ListObjectsV2Request listObjectsV2Request) {
        if (listObjectsV2Request == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)listObjectsV2Request, "S3Client");
        request.setHttpMethod(HttpMethodName.GET);
        if (listObjectsV2Request.requestPayerAsString() != null) {
            request.addHeader("x-amz-request-payer", StringConversion.fromString((String)listObjectsV2Request.requestPayerAsString()));
        }
        String uriResourcePath = "/{Bucket}?list-type=2";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParametersToRequest((Request)request, (String)uriResourcePath);
        uriResourcePath = PathMarshaller.NON_GREEDY.marshall(uriResourcePath, "Bucket", listObjectsV2Request.bucket());
        request.setResourcePath(uriResourcePath);
        if (listObjectsV2Request.delimiter() != null) {
            request.addParameter("delimiter", StringConversion.fromString((String)listObjectsV2Request.delimiter()));
        }
        if (listObjectsV2Request.encodingTypeAsString() != null) {
            request.addParameter("encoding-type", StringConversion.fromString((String)listObjectsV2Request.encodingTypeAsString()));
        }
        if (listObjectsV2Request.maxKeys() != null) {
            request.addParameter("max-keys", StringConversion.fromInteger((Integer)listObjectsV2Request.maxKeys()));
        }
        if (listObjectsV2Request.prefix() != null) {
            request.addParameter("prefix", StringConversion.fromString((String)listObjectsV2Request.prefix()));
        }
        if (listObjectsV2Request.continuationToken() != null) {
            request.addParameter("continuation-token", StringConversion.fromString((String)listObjectsV2Request.continuationToken()));
        }
        if (listObjectsV2Request.fetchOwner() != null) {
            request.addParameter("fetch-owner", StringConversion.fromBoolean((Boolean)listObjectsV2Request.fetchOwner()));
        }
        if (listObjectsV2Request.startAfter() != null) {
            request.addParameter("start-after", StringConversion.fromString((String)listObjectsV2Request.startAfter()));
        }
        return request;
    }
}

