/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.core.util.UriResourcePathUtils;
import software.amazon.awssdk.services.s3.model.ListMultipartUploadsRequest;

public class ListMultipartUploadsRequestMarshaller
implements Marshaller<Request<ListMultipartUploadsRequest>, ListMultipartUploadsRequest> {
    public Request<ListMultipartUploadsRequest> marshall(ListMultipartUploadsRequest listMultipartUploadsRequest) {
        if (listMultipartUploadsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)listMultipartUploadsRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/{Bucket}?uploads";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParametersToRequest((Request)request, (String)uriResourcePath);
        uriResourcePath = PathMarshaller.NON_GREEDY.marshall(uriResourcePath, "Bucket", listMultipartUploadsRequest.bucket());
        request.setResourcePath(uriResourcePath);
        if (listMultipartUploadsRequest.delimiter() != null) {
            request.addParameter("delimiter", StringConversion.fromString((String)listMultipartUploadsRequest.delimiter()));
        }
        if (listMultipartUploadsRequest.encodingTypeAsString() != null) {
            request.addParameter("encoding-type", StringConversion.fromString((String)listMultipartUploadsRequest.encodingTypeAsString()));
        }
        if (listMultipartUploadsRequest.keyMarker() != null) {
            request.addParameter("key-marker", StringConversion.fromString((String)listMultipartUploadsRequest.keyMarker()));
        }
        if (listMultipartUploadsRequest.maxUploads() != null) {
            request.addParameter("max-uploads", StringConversion.fromInteger((Integer)listMultipartUploadsRequest.maxUploads()));
        }
        if (listMultipartUploadsRequest.prefix() != null) {
            request.addParameter("prefix", StringConversion.fromString((String)listMultipartUploadsRequest.prefix()));
        }
        if (listMultipartUploadsRequest.uploadIdMarker() != null) {
            request.addParameter("upload-id-marker", StringConversion.fromString((String)listMultipartUploadsRequest.uploadIdMarker()));
        }
        return request;
    }
}

