/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.time.Instant;
import java.util.Map;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.core.util.UriResourcePathUtils;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest;

public class CreateMultipartUploadRequestMarshaller
implements Marshaller<Request<CreateMultipartUploadRequest>, CreateMultipartUploadRequest> {
    public Request<CreateMultipartUploadRequest> marshall(CreateMultipartUploadRequest createMultipartUploadRequest) {
        if (createMultipartUploadRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createMultipartUploadRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.POST);
        if (createMultipartUploadRequest.aclAsString() != null) {
            request.addHeader("x-amz-acl", StringConversion.fromString((String)createMultipartUploadRequest.aclAsString()));
        }
        if (createMultipartUploadRequest.cacheControl() != null) {
            request.addHeader("Cache-Control", StringConversion.fromString((String)createMultipartUploadRequest.cacheControl()));
        }
        if (createMultipartUploadRequest.contentDisposition() != null) {
            request.addHeader("Content-Disposition", StringConversion.fromString((String)createMultipartUploadRequest.contentDisposition()));
        }
        if (createMultipartUploadRequest.contentEncoding() != null) {
            request.addHeader("Content-Encoding", StringConversion.fromString((String)createMultipartUploadRequest.contentEncoding()));
        }
        if (createMultipartUploadRequest.contentLanguage() != null) {
            request.addHeader("Content-Language", StringConversion.fromString((String)createMultipartUploadRequest.contentLanguage()));
        }
        if (createMultipartUploadRequest.contentType() != null) {
            request.addHeader("Content-Type", StringConversion.fromString((String)createMultipartUploadRequest.contentType()));
        }
        if (createMultipartUploadRequest.expires() != null) {
            request.addHeader("Expires", StringConversion.fromInstant((Instant)createMultipartUploadRequest.expires()));
        }
        if (createMultipartUploadRequest.grantFullControl() != null) {
            request.addHeader("x-amz-grant-full-control", StringConversion.fromString((String)createMultipartUploadRequest.grantFullControl()));
        }
        if (createMultipartUploadRequest.grantRead() != null) {
            request.addHeader("x-amz-grant-read", StringConversion.fromString((String)createMultipartUploadRequest.grantRead()));
        }
        if (createMultipartUploadRequest.grantReadACP() != null) {
            request.addHeader("x-amz-grant-read-acp", StringConversion.fromString((String)createMultipartUploadRequest.grantReadACP()));
        }
        if (createMultipartUploadRequest.grantWriteACP() != null) {
            request.addHeader("x-amz-grant-write-acp", StringConversion.fromString((String)createMultipartUploadRequest.grantWriteACP()));
        }
        if (createMultipartUploadRequest.serverSideEncryptionAsString() != null) {
            request.addHeader("x-amz-server-side-encryption", StringConversion.fromString((String)createMultipartUploadRequest.serverSideEncryptionAsString()));
        }
        if (createMultipartUploadRequest.storageClassAsString() != null) {
            request.addHeader("x-amz-storage-class", StringConversion.fromString((String)createMultipartUploadRequest.storageClassAsString()));
        }
        if (createMultipartUploadRequest.websiteRedirectLocation() != null) {
            request.addHeader("x-amz-website-redirect-location", StringConversion.fromString((String)createMultipartUploadRequest.websiteRedirectLocation()));
        }
        if (createMultipartUploadRequest.sseCustomerAlgorithm() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-algorithm", StringConversion.fromString((String)createMultipartUploadRequest.sseCustomerAlgorithm()));
        }
        if (createMultipartUploadRequest.sseCustomerKey() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-key", StringConversion.fromString((String)createMultipartUploadRequest.sseCustomerKey()));
        }
        if (createMultipartUploadRequest.sseCustomerKeyMD5() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-key-MD5", StringConversion.fromString((String)createMultipartUploadRequest.sseCustomerKeyMD5()));
        }
        if (createMultipartUploadRequest.ssekmsKeyId() != null) {
            request.addHeader("x-amz-server-side-encryption-aws-kms-key-id", StringConversion.fromString((String)createMultipartUploadRequest.ssekmsKeyId()));
        }
        if (createMultipartUploadRequest.requestPayerAsString() != null) {
            request.addHeader("x-amz-request-payer", StringConversion.fromString((String)createMultipartUploadRequest.requestPayerAsString()));
        }
        if (createMultipartUploadRequest.metadata() != null) {
            createMultipartUploadRequest.metadata().entrySet().forEach(arg_0 -> CreateMultipartUploadRequestMarshaller.lambda$marshall$0((Request)request, arg_0));
        }
        String uriResourcePath = "/{Bucket}/{Key+}?uploads";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParametersToRequest((Request)request, (String)uriResourcePath);
        uriResourcePath = PathMarshaller.NON_GREEDY.marshall(uriResourcePath, "Bucket", createMultipartUploadRequest.bucket());
        uriResourcePath = PathMarshaller.GREEDY.marshall(uriResourcePath, "Key", createMultipartUploadRequest.key());
        request.setResourcePath(uriResourcePath);
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        request.addHeader("Content-Length", String.valueOf(0));
        return request;
    }

    private static /* synthetic */ void lambda$marshall$0(Request request, Map.Entry e) {
        if (((String)e.getKey()).startsWith("x-amz-meta-")) {
            request.addHeader((String)e.getKey(), (String)e.getValue());
        } else {
            request.addHeader("x-amz-meta-" + (String)e.getKey(), (String)e.getValue());
        }
    }
}

