/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.core.util.xml.XmlWriter;
import software.amazon.awssdk.services.s3.model.CreateBucketConfiguration;
import software.amazon.awssdk.services.s3.model.CreateBucketRequest;
import software.amazon.awssdk.utils.Md5Utils;
import software.amazon.awssdk.utils.StringInputStream;

public class CreateBucketRequestMarshaller
implements Marshaller<Request<CreateBucketRequest>, CreateBucketRequest> {
    public Request<CreateBucketRequest> marshall(CreateBucketRequest createBucketRequest) {
        if (createBucketRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createBucketRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.PUT);
        if (createBucketRequest.aclAsString() != null) {
            request.addHeader("x-amz-acl", StringConversion.fromString((String)createBucketRequest.aclAsString()));
        }
        if (createBucketRequest.grantFullControl() != null) {
            request.addHeader("x-amz-grant-full-control", StringConversion.fromString((String)createBucketRequest.grantFullControl()));
        }
        if (createBucketRequest.grantRead() != null) {
            request.addHeader("x-amz-grant-read", StringConversion.fromString((String)createBucketRequest.grantRead()));
        }
        if (createBucketRequest.grantReadACP() != null) {
            request.addHeader("x-amz-grant-read-acp", StringConversion.fromString((String)createBucketRequest.grantReadACP()));
        }
        if (createBucketRequest.grantWrite() != null) {
            request.addHeader("x-amz-grant-write", StringConversion.fromString((String)createBucketRequest.grantWrite()));
        }
        if (createBucketRequest.grantWriteACP() != null) {
            request.addHeader("x-amz-grant-write-acp", StringConversion.fromString((String)createBucketRequest.grantWriteACP()));
        }
        String uriResourcePath = "/{Bucket}";
        uriResourcePath = PathMarshaller.NON_GREEDY.marshall(uriResourcePath, "Bucket", createBucketRequest.bucket());
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = null;
            CreateBucketConfiguration createBucketConfiguration = createBucketRequest.createBucketConfiguration();
            if (createBucketConfiguration != null) {
                stringWriter = new StringWriter();
                XmlWriter xmlWriter = new XmlWriter((Writer)stringWriter, "http://s3.amazonaws.com/doc/2006-03-01/");
                xmlWriter.startElement("CreateBucketConfiguration");
                if (createBucketConfiguration.locationConstraintAsString() != null) {
                    xmlWriter.startElement("LocationConstraint").value(createBucketConfiguration.locationConstraintAsString()).endElement();
                }
                xmlWriter.endElement();
            }
            if (stringWriter != null) {
                if (!request.getHeaders().containsKey("Content-MD5")) {
                    request.addHeader("Content-MD5", Md5Utils.md5AsBase64((byte[])stringWriter.getBuffer().toString().getBytes(StandardCharsets.UTF_8)));
                }
                request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
                request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StandardCharsets.UTF_8).length));
            }
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw SdkClientException.builder().message("Unable to marshall request to XML: " + t.getMessage()).cause(t).build();
        }
        return request;
    }
}

