/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.s3.model.CORSConfiguration;
import software.amazon.awssdk.services.s3.model.S3Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutBucketCorsRequest
extends S3Request
implements ToCopyableBuilder<Builder, PutBucketCorsRequest> {
    private final String bucket;
    private final CORSConfiguration corsConfiguration;
    private final String contentMD5;

    private PutBucketCorsRequest(BuilderImpl builder) {
        super(builder);
        this.bucket = builder.bucket;
        this.corsConfiguration = builder.corsConfiguration;
        this.contentMD5 = builder.contentMD5;
    }

    public String bucket() {
        return this.bucket;
    }

    public CORSConfiguration corsConfiguration() {
        return this.corsConfiguration;
    }

    public String contentMD5() {
        return this.contentMD5;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.corsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentMD5());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutBucketCorsRequest)) {
            return false;
        }
        PutBucketCorsRequest other = (PutBucketCorsRequest)((Object)obj);
        return Objects.equals(this.bucket(), other.bucket()) && Objects.equals(this.corsConfiguration(), other.corsConfiguration()) && Objects.equals(this.contentMD5(), other.contentMD5());
    }

    public String toString() {
        return ToString.builder((String)"PutBucketCorsRequest").add("Bucket", (Object)this.bucket()).add("CORSConfiguration", (Object)this.corsConfiguration()).add("ContentMD5", (Object)this.contentMD5()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Bucket": {
                return Optional.ofNullable(clazz.cast(this.bucket()));
            }
            case "CORSConfiguration": {
                return Optional.ofNullable(clazz.cast(this.corsConfiguration()));
            }
            case "ContentMD5": {
                return Optional.ofNullable(clazz.cast(this.contentMD5()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends S3Request.BuilderImpl
    implements Builder {
        private String bucket;
        private CORSConfiguration corsConfiguration;
        private String contentMD5;

        private BuilderImpl() {
        }

        private BuilderImpl(PutBucketCorsRequest model) {
            super(model);
            this.bucket(model.bucket);
            this.corsConfiguration(model.corsConfiguration);
            this.contentMD5(model.contentMD5);
        }

        public final String getBucket() {
            return this.bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final CORSConfiguration.Builder getCORSConfiguration() {
            return this.corsConfiguration != null ? this.corsConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder corsConfiguration(CORSConfiguration corsConfiguration) {
            this.corsConfiguration = corsConfiguration;
            return this;
        }

        public final void setCORSConfiguration(CORSConfiguration.BuilderImpl corsConfiguration) {
            this.corsConfiguration = corsConfiguration != null ? corsConfiguration.build() : null;
        }

        public final String getContentMD5() {
            return this.contentMD5;
        }

        @Override
        public final Builder contentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
            return this;
        }

        public final void setContentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutBucketCorsRequest build() {
            return new PutBucketCorsRequest(this);
        }
    }

    public static interface Builder
    extends S3Request.Builder,
    CopyableBuilder<Builder, PutBucketCorsRequest> {
        public Builder bucket(String var1);

        public Builder corsConfiguration(CORSConfiguration var1);

        default public Builder corsConfiguration(Consumer<CORSConfiguration.Builder> corsConfiguration) {
            return this.corsConfiguration((CORSConfiguration)((CORSConfiguration.Builder)CORSConfiguration.builder().applyMutation(corsConfiguration)).build());
        }

        public Builder contentMD5(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

