/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.s3.model.TargetGrant;
import software.amazon.awssdk.services.s3.model.TargetGrantsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LoggingEnabled
implements ToCopyableBuilder<Builder, LoggingEnabled> {
    private final String targetBucket;
    private final List<TargetGrant> targetGrants;
    private final String targetPrefix;

    private LoggingEnabled(BuilderImpl builder) {
        this.targetBucket = builder.targetBucket;
        this.targetGrants = builder.targetGrants;
        this.targetPrefix = builder.targetPrefix;
    }

    public String targetBucket() {
        return this.targetBucket;
    }

    public List<TargetGrant> targetGrants() {
        return this.targetGrants;
    }

    public String targetPrefix() {
        return this.targetPrefix;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.targetBucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetGrants());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetPrefix());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoggingEnabled)) {
            return false;
        }
        LoggingEnabled other = (LoggingEnabled)obj;
        return Objects.equals(this.targetBucket(), other.targetBucket()) && Objects.equals(this.targetGrants(), other.targetGrants()) && Objects.equals(this.targetPrefix(), other.targetPrefix());
    }

    public String toString() {
        return ToString.builder((String)"LoggingEnabled").add("TargetBucket", (Object)this.targetBucket()).add("TargetGrants", this.targetGrants()).add("TargetPrefix", (Object)this.targetPrefix()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetBucket": {
                return Optional.ofNullable(clazz.cast(this.targetBucket()));
            }
            case "TargetGrants": {
                return Optional.ofNullable(clazz.cast(this.targetGrants()));
            }
            case "TargetPrefix": {
                return Optional.ofNullable(clazz.cast(this.targetPrefix()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String targetBucket;
        private List<TargetGrant> targetGrants = DefaultSdkAutoConstructList.getInstance();
        private String targetPrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(LoggingEnabled model) {
            this.targetBucket(model.targetBucket);
            this.targetGrants(model.targetGrants);
            this.targetPrefix(model.targetPrefix);
        }

        public final String getTargetBucket() {
            return this.targetBucket;
        }

        @Override
        public final Builder targetBucket(String targetBucket) {
            this.targetBucket = targetBucket;
            return this;
        }

        public final void setTargetBucket(String targetBucket) {
            this.targetBucket = targetBucket;
        }

        public final Collection<TargetGrant.Builder> getTargetGrants() {
            return this.targetGrants != null ? (Collection)this.targetGrants.stream().map(TargetGrant::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targetGrants(Collection<TargetGrant> targetGrants) {
            this.targetGrants = TargetGrantsCopier.copy(targetGrants);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetGrants(TargetGrant ... targetGrants) {
            this.targetGrants(Arrays.asList(targetGrants));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetGrants(Consumer<TargetGrant.Builder> ... targetGrants) {
            this.targetGrants(Stream.of(targetGrants).map(c -> (TargetGrant)((TargetGrant.Builder)TargetGrant.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTargetGrants(Collection<TargetGrant.BuilderImpl> targetGrants) {
            this.targetGrants = TargetGrantsCopier.copyFromBuilder(targetGrants);
        }

        public final String getTargetPrefix() {
            return this.targetPrefix;
        }

        @Override
        public final Builder targetPrefix(String targetPrefix) {
            this.targetPrefix = targetPrefix;
            return this;
        }

        public final void setTargetPrefix(String targetPrefix) {
            this.targetPrefix = targetPrefix;
        }

        public LoggingEnabled build() {
            return new LoggingEnabled(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LoggingEnabled> {
        public Builder targetBucket(String var1);

        public Builder targetGrants(Collection<TargetGrant> var1);

        public Builder targetGrants(TargetGrant ... var1);

        public Builder targetGrants(Consumer<TargetGrant.Builder> ... var1);

        public Builder targetPrefix(String var1);
    }
}

