/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.Rule;
import software.amazon.awssdk.services.s3.transform.AbortIncompleteMultipartUploadUnmarshaller;
import software.amazon.awssdk.services.s3.transform.LifecycleExpirationUnmarshaller;
import software.amazon.awssdk.services.s3.transform.NoncurrentVersionExpirationUnmarshaller;
import software.amazon.awssdk.services.s3.transform.NoncurrentVersionTransitionUnmarshaller;
import software.amazon.awssdk.services.s3.transform.TransitionUnmarshaller;

public class RuleUnmarshaller
implements Unmarshaller<Rule, StaxUnmarshallerContext> {
    private static final RuleUnmarshaller INSTANCE = new RuleUnmarshaller();

    public Rule unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        Rule.Builder rule = Rule.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Expiration", targetDepth)) {
                    rule.expiration(LifecycleExpirationUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ID", targetDepth)) {
                    rule.id(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Prefix", targetDepth)) {
                    rule.prefix(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Status", targetDepth)) {
                    rule.status(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Transition", targetDepth)) {
                    rule.transition(TransitionUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("NoncurrentVersionTransition", targetDepth)) {
                    rule.noncurrentVersionTransition(NoncurrentVersionTransitionUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("NoncurrentVersionExpiration", targetDepth)) {
                    rule.noncurrentVersionExpiration(NoncurrentVersionExpirationUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("AbortIncompleteMultipartUpload", targetDepth)) continue;
                rule.abortIncompleteMultipartUpload(AbortIncompleteMultipartUploadUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (Rule)rule.build();
    }

    public static RuleUnmarshaller getInstance() {
        return INSTANCE;
    }
}

