/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.core.util.UriResourcePathUtils;
import software.amazon.awssdk.core.util.xml.XmlWriter;
import software.amazon.awssdk.services.s3.model.GlacierJobParameters;
import software.amazon.awssdk.services.s3.model.RestoreObjectRequest;
import software.amazon.awssdk.services.s3.model.RestoreRequest;
import software.amazon.awssdk.utils.Md5Utils;
import software.amazon.awssdk.utils.StringInputStream;

public class RestoreObjectRequestMarshaller
implements Marshaller<Request<RestoreObjectRequest>, RestoreObjectRequest> {
    public Request<RestoreObjectRequest> marshall(RestoreObjectRequest restoreObjectRequest) {
        if (restoreObjectRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)restoreObjectRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.POST);
        if (restoreObjectRequest.requestPayerAsString() != null) {
            request.addHeader("x-amz-request-payer", StringConversion.fromString((String)restoreObjectRequest.requestPayerAsString()));
        }
        String uriResourcePath = "/{Bucket}/{Key+}?restore";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParametersToRequest((Request)request, (String)uriResourcePath);
        uriResourcePath = PathMarshaller.NON_GREEDY.marshall(uriResourcePath, "Bucket", restoreObjectRequest.bucket());
        uriResourcePath = PathMarshaller.GREEDY.marshall(uriResourcePath, "Key", restoreObjectRequest.key());
        request.setResourcePath(uriResourcePath);
        if (restoreObjectRequest.versionId() != null) {
            request.addParameter("versionId", StringConversion.fromString((String)restoreObjectRequest.versionId()));
        }
        try {
            StringWriter stringWriter = null;
            RestoreRequest restoreRequest = restoreObjectRequest.restoreRequest();
            if (restoreRequest != null) {
                GlacierJobParameters glacierJobParameters;
                stringWriter = new StringWriter();
                XmlWriter xmlWriter = new XmlWriter((Writer)stringWriter, "http://s3.amazonaws.com/doc/2006-03-01/");
                xmlWriter.startElement("RestoreRequest");
                if (restoreRequest.days() != null) {
                    xmlWriter.startElement("Days").value((Object)restoreRequest.days()).endElement();
                }
                if ((glacierJobParameters = restoreRequest.glacierJobParameters()) != null) {
                    xmlWriter.startElement("GlacierJobParameters");
                    if (glacierJobParameters.tierAsString() != null) {
                        xmlWriter.startElement("Tier").value(glacierJobParameters.tierAsString()).endElement();
                    }
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }
            if (stringWriter != null) {
                if (!request.getHeaders().containsKey("Content-MD5")) {
                    request.addHeader("Content-MD5", Md5Utils.md5AsBase64((byte[])stringWriter.getBuffer().toString().getBytes(StandardCharsets.UTF_8)));
                }
                request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
                request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StandardCharsets.UTF_8).length));
            }
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw SdkClientException.builder().message("Unable to marshall request to XML: " + t.getMessage()).cause(t).build();
        }
        return request;
    }
}

