/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.core.util.UriResourcePathUtils;
import software.amazon.awssdk.services.s3.model.ListBucketMetricsConfigurationsRequest;

public class ListBucketMetricsConfigurationsRequestMarshaller
implements Marshaller<Request<ListBucketMetricsConfigurationsRequest>, ListBucketMetricsConfigurationsRequest> {
    public Request<ListBucketMetricsConfigurationsRequest> marshall(ListBucketMetricsConfigurationsRequest listBucketMetricsConfigurationsRequest) {
        if (listBucketMetricsConfigurationsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)listBucketMetricsConfigurationsRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/{Bucket}?metrics";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParametersToRequest((Request)request, (String)uriResourcePath);
        uriResourcePath = PathMarshaller.NON_GREEDY.marshall(uriResourcePath, "Bucket", listBucketMetricsConfigurationsRequest.bucket());
        request.setResourcePath(uriResourcePath);
        if (listBucketMetricsConfigurationsRequest.continuationToken() != null) {
            request.addParameter("continuation-token", StringConversion.fromString((String)listBucketMetricsConfigurationsRequest.continuationToken()));
        }
        return request;
    }
}

