/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.MapEntry;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;
import software.amazon.awssdk.utils.DateUtils;

public class HeadObjectResponseUnmarshaller
implements Unmarshaller<HeadObjectResponse, StaxUnmarshallerContext> {
    private static final HeadObjectResponseUnmarshaller INSTANCE = new HeadObjectResponseUnmarshaller();

    public HeadObjectResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        HeadObjectResponse.Builder headObjectResponse = HeadObjectResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        if (context.isStartOfDocument()) {
            context.setCurrentHeader("x-amz-delete-marker");
            headObjectResponse.deleteMarker(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
            context.setCurrentHeader("accept-ranges");
            headObjectResponse.acceptRanges(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
            context.setCurrentHeader("x-amz-expiration");
            headObjectResponse.expiration(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
            context.setCurrentHeader("x-amz-restore");
            headObjectResponse.restore(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
            context.setCurrentHeader("Last-Modified");
            headObjectResponse.lastModified(DateUtils.parseRfc1123Date((String)context.readText()));
            context.setCurrentHeader("Content-Length");
            headObjectResponse.contentLength(SimpleTypeStaxUnmarshallers.LongUnmarshaller.getInstance().unmarshall(context));
            context.setCurrentHeader("ETag");
            headObjectResponse.eTag(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
            context.setCurrentHeader("x-amz-missing-meta");
            headObjectResponse.missingMeta(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
            context.setCurrentHeader("x-amz-version-id");
            headObjectResponse.versionId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
            context.setCurrentHeader("Cache-Control");
            headObjectResponse.cacheControl(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
            context.setCurrentHeader("Content-Disposition");
            headObjectResponse.contentDisposition(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
            context.setCurrentHeader("Content-Encoding");
            headObjectResponse.contentEncoding(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
            context.setCurrentHeader("Content-Language");
            headObjectResponse.contentLanguage(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
            context.setCurrentHeader("Content-Type");
            headObjectResponse.contentType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
            context.setCurrentHeader("Expires");
            headObjectResponse.expires(DateUtils.parseRfc1123Date((String)context.readText()));
            context.setCurrentHeader("x-amz-website-redirect-location");
            headObjectResponse.websiteRedirectLocation(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
            context.setCurrentHeader("x-amz-server-side-encryption");
            headObjectResponse.serverSideEncryption(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
            context.setCurrentHeader("x-amz-server-side-encryption-customer-algorithm");
            headObjectResponse.sseCustomerAlgorithm(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
            context.setCurrentHeader("x-amz-server-side-encryption-customer-key-MD5");
            headObjectResponse.sseCustomerKeyMD5(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
            context.setCurrentHeader("x-amz-server-side-encryption-aws-kms-key-id");
            headObjectResponse.ssekmsKeyId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
            context.setCurrentHeader("x-amz-storage-class");
            headObjectResponse.storageClass(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
            context.setCurrentHeader("x-amz-request-charged");
            headObjectResponse.requestCharged(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
            context.setCurrentHeader("x-amz-replication-status");
            headObjectResponse.replicationStatus(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
            context.setCurrentHeader("x-amz-mp-parts-count");
            headObjectResponse.partsCount(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
        }
        HashMap<String, String> metadata = new HashMap<String, String>();
        context.getHeaders().entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("x-amz-meta-")).forEach(e -> metadata.put(((String)e.getKey()).replace("x-amz-meta-", ""), (String)e.getValue()));
        headObjectResponse.metadata(metadata);
        return (HeadObjectResponse)((Object)headObjectResponse.build());
    }

    public static HeadObjectResponseUnmarshaller getInstance() {
        return INSTANCE;
    }

    private static class MetadataMapEntryUnmarshaller
    implements Unmarshaller<Map.Entry<String, String>, StaxUnmarshallerContext> {
        private static final MetadataMapEntryUnmarshaller INSTANCE = new MetadataMapEntryUnmarshaller();

        private MetadataMapEntryUnmarshaller() {
        }

        public Map.Entry<String, String> unmarshall(StaxUnmarshallerContext context) throws Exception {
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            MapEntry entry = new MapEntry();
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    return entry;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("key", targetDepth)) {
                        entry.setKey((Object)SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("value", targetDepth)) continue;
                    entry.setValue((Object)SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            return entry;
        }

        public static MetadataMapEntryUnmarshaller getInstance() {
            return INSTANCE;
        }
    }
}

