/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.time.Instant;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;

public class HeadObjectRequestMarshaller
implements Marshaller<Request<HeadObjectRequest>, HeadObjectRequest> {
    public Request<HeadObjectRequest> marshall(HeadObjectRequest headObjectRequest) {
        if (headObjectRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)headObjectRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.HEAD);
        if (headObjectRequest.ifMatch() != null) {
            request.addHeader("If-Match", StringConversion.fromString((String)headObjectRequest.ifMatch()));
        }
        if (headObjectRequest.ifModifiedSince() != null) {
            request.addHeader("If-Modified-Since", StringConversion.fromInstant((Instant)headObjectRequest.ifModifiedSince()));
        }
        if (headObjectRequest.ifNoneMatch() != null) {
            request.addHeader("If-None-Match", StringConversion.fromString((String)headObjectRequest.ifNoneMatch()));
        }
        if (headObjectRequest.ifUnmodifiedSince() != null) {
            request.addHeader("If-Unmodified-Since", StringConversion.fromInstant((Instant)headObjectRequest.ifUnmodifiedSince()));
        }
        if (headObjectRequest.range() != null) {
            request.addHeader("Range", StringConversion.fromString((String)headObjectRequest.range()));
        }
        if (headObjectRequest.sseCustomerAlgorithm() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-algorithm", StringConversion.fromString((String)headObjectRequest.sseCustomerAlgorithm()));
        }
        if (headObjectRequest.sseCustomerKey() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-key", StringConversion.fromString((String)headObjectRequest.sseCustomerKey()));
        }
        if (headObjectRequest.sseCustomerKeyMD5() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-key-MD5", StringConversion.fromString((String)headObjectRequest.sseCustomerKeyMD5()));
        }
        if (headObjectRequest.requestPayerAsString() != null) {
            request.addHeader("x-amz-request-payer", StringConversion.fromString((String)headObjectRequest.requestPayerAsString()));
        }
        String uriResourcePath = "/{Bucket}/{Key+}";
        uriResourcePath = PathMarshaller.NON_GREEDY.marshall(uriResourcePath, "Bucket", headObjectRequest.bucket());
        uriResourcePath = PathMarshaller.GREEDY.marshall(uriResourcePath, "Key", headObjectRequest.key());
        request.setResourcePath(uriResourcePath);
        if (headObjectRequest.versionId() != null) {
            request.addParameter("versionId", StringConversion.fromString((String)headObjectRequest.versionId()));
        }
        if (headObjectRequest.partNumber() != null) {
            request.addParameter("partNumber", StringConversion.fromInteger((Integer)headObjectRequest.partNumber()));
        }
        return request;
    }
}

