/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshallers;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.s3.model.ListPartsRequest;

public class ListPartsRequestMarshaller
implements Marshaller<Request<ListPartsRequest>, ListPartsRequest> {
    public Request<ListPartsRequest> marshall(ListPartsRequest listPartsRequest) {
        if (listPartsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)listPartsRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.GET);
        if (listPartsRequest.requestPayerAsString() != null) {
            request.addHeader("x-amz-request-payer", StringUtils.fromString((String)listPartsRequest.requestPayerAsString()));
        }
        String uriResourcePath = "/{Bucket}/{Key+}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", listPartsRequest.bucket());
        uriResourcePath = PathMarshallers.GREEDY.marshall(uriResourcePath, "Key", listPartsRequest.key());
        request.setResourcePath(uriResourcePath);
        if (listPartsRequest.maxParts() != null) {
            request.addParameter("max-parts", StringUtils.fromInteger((Integer)listPartsRequest.maxParts()));
        }
        if (listPartsRequest.partNumberMarker() != null) {
            request.addParameter("part-number-marker", StringUtils.fromInteger((Integer)listPartsRequest.partNumberMarker()));
        }
        if (listPartsRequest.uploadId() != null) {
            request.addParameter("uploadId", StringUtils.fromString((String)listPartsRequest.uploadId()));
        }
        return request;
    }
}

