/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshallers;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.s3.model.ListObjectsRequest;

public class ListObjectsRequestMarshaller
implements Marshaller<Request<ListObjectsRequest>, ListObjectsRequest> {
    public Request<ListObjectsRequest> marshall(ListObjectsRequest listObjectsRequest) {
        if (listObjectsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)listObjectsRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.GET);
        if (listObjectsRequest.requestPayerAsString() != null) {
            request.addHeader("x-amz-request-payer", StringUtils.fromString((String)listObjectsRequest.requestPayerAsString()));
        }
        String uriResourcePath = "/{Bucket}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", listObjectsRequest.bucket());
        request.setResourcePath(uriResourcePath);
        if (listObjectsRequest.delimiter() != null) {
            request.addParameter("delimiter", StringUtils.fromString((String)listObjectsRequest.delimiter()));
        }
        if (listObjectsRequest.encodingTypeAsString() != null) {
            request.addParameter("encoding-type", StringUtils.fromString((String)listObjectsRequest.encodingTypeAsString()));
        }
        if (listObjectsRequest.marker() != null) {
            request.addParameter("marker", StringUtils.fromString((String)listObjectsRequest.marker()));
        }
        if (listObjectsRequest.maxKeys() != null) {
            request.addParameter("max-keys", StringUtils.fromInteger((Integer)listObjectsRequest.maxKeys()));
        }
        if (listObjectsRequest.prefix() != null) {
            request.addParameter("prefix", StringUtils.fromString((String)listObjectsRequest.prefix()));
        }
        return request;
    }
}

