/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshallers;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.core.util.UriResourcePathUtils;
import software.amazon.awssdk.services.s3.model.GetBucketAnalyticsConfigurationRequest;

public class GetBucketAnalyticsConfigurationRequestMarshaller
implements Marshaller<Request<GetBucketAnalyticsConfigurationRequest>, GetBucketAnalyticsConfigurationRequest> {
    public Request<GetBucketAnalyticsConfigurationRequest> marshall(GetBucketAnalyticsConfigurationRequest getBucketAnalyticsConfigurationRequest) {
        if (getBucketAnalyticsConfigurationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)getBucketAnalyticsConfigurationRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/{Bucket}?analytics";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParametersToRequest((Request)request, (String)uriResourcePath);
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", getBucketAnalyticsConfigurationRequest.bucket());
        request.setResourcePath(uriResourcePath);
        if (getBucketAnalyticsConfigurationRequest.id() != null) {
            request.addParameter("id", StringUtils.fromString((String)getBucketAnalyticsConfigurationRequest.id()));
        }
        return request;
    }
}

