/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshallers;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;

public class DeleteObjectRequestMarshaller
implements Marshaller<Request<DeleteObjectRequest>, DeleteObjectRequest> {
    public Request<DeleteObjectRequest> marshall(DeleteObjectRequest deleteObjectRequest) {
        if (deleteObjectRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)deleteObjectRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.DELETE);
        if (deleteObjectRequest.mfa() != null) {
            request.addHeader("x-amz-mfa", StringUtils.fromString((String)deleteObjectRequest.mfa()));
        }
        if (deleteObjectRequest.requestPayerAsString() != null) {
            request.addHeader("x-amz-request-payer", StringUtils.fromString((String)deleteObjectRequest.requestPayerAsString()));
        }
        String uriResourcePath = "/{Bucket}/{Key+}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", deleteObjectRequest.bucket());
        uriResourcePath = PathMarshallers.GREEDY.marshall(uriResourcePath, "Key", deleteObjectRequest.key());
        request.setResourcePath(uriResourcePath);
        if (deleteObjectRequest.versionId() != null) {
            request.addParameter("versionId", StringUtils.fromString((String)deleteObjectRequest.versionId()));
        }
        return request;
    }
}

