/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.s3.model.RequestPaymentConfiguration;
import software.amazon.awssdk.services.s3.model.S3Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutBucketRequestPaymentRequest
extends S3Request
implements ToCopyableBuilder<Builder, PutBucketRequestPaymentRequest> {
    private final String bucket;
    private final String contentMD5;
    private final RequestPaymentConfiguration requestPaymentConfiguration;

    private PutBucketRequestPaymentRequest(BuilderImpl builder) {
        super(builder);
        this.bucket = builder.bucket;
        this.contentMD5 = builder.contentMD5;
        this.requestPaymentConfiguration = builder.requestPaymentConfiguration;
    }

    public String bucket() {
        return this.bucket;
    }

    public String contentMD5() {
        return this.contentMD5;
    }

    public RequestPaymentConfiguration requestPaymentConfiguration() {
        return this.requestPaymentConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentMD5());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestPaymentConfiguration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutBucketRequestPaymentRequest)) {
            return false;
        }
        PutBucketRequestPaymentRequest other = (PutBucketRequestPaymentRequest)((Object)obj);
        return Objects.equals(this.bucket(), other.bucket()) && Objects.equals(this.contentMD5(), other.contentMD5()) && Objects.equals(this.requestPaymentConfiguration(), other.requestPaymentConfiguration());
    }

    public String toString() {
        return ToString.builder((String)"PutBucketRequestPaymentRequest").add("Bucket", (Object)this.bucket()).add("ContentMD5", (Object)this.contentMD5()).add("RequestPaymentConfiguration", (Object)this.requestPaymentConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Bucket": {
                return Optional.of(clazz.cast(this.bucket()));
            }
            case "ContentMD5": {
                return Optional.of(clazz.cast(this.contentMD5()));
            }
            case "RequestPaymentConfiguration": {
                return Optional.of(clazz.cast(this.requestPaymentConfiguration()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends S3Request.BuilderImpl
    implements Builder {
        private String bucket;
        private String contentMD5;
        private RequestPaymentConfiguration requestPaymentConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PutBucketRequestPaymentRequest model) {
            super(model);
            this.bucket(model.bucket);
            this.contentMD5(model.contentMD5);
            this.requestPaymentConfiguration(model.requestPaymentConfiguration);
        }

        public final String getBucket() {
            return this.bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getContentMD5() {
            return this.contentMD5;
        }

        @Override
        public final Builder contentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
            return this;
        }

        public final void setContentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
        }

        public final RequestPaymentConfiguration.Builder getRequestPaymentConfiguration() {
            return this.requestPaymentConfiguration != null ? this.requestPaymentConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder requestPaymentConfiguration(RequestPaymentConfiguration requestPaymentConfiguration) {
            this.requestPaymentConfiguration = requestPaymentConfiguration;
            return this;
        }

        public final void setRequestPaymentConfiguration(RequestPaymentConfiguration.BuilderImpl requestPaymentConfiguration) {
            this.requestPaymentConfiguration = requestPaymentConfiguration != null ? requestPaymentConfiguration.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public PutBucketRequestPaymentRequest build() {
            return new PutBucketRequestPaymentRequest(this);
        }
    }

    public static interface Builder
    extends S3Request.Builder,
    CopyableBuilder<Builder, PutBucketRequestPaymentRequest> {
        public Builder bucket(String var1);

        public Builder contentMD5(String var1);

        public Builder requestPaymentConfiguration(RequestPaymentConfiguration var1);

        default public Builder requestPaymentConfiguration(Consumer<RequestPaymentConfiguration.Builder> requestPaymentConfiguration) {
            return this.requestPaymentConfiguration((RequestPaymentConfiguration)((RequestPaymentConfiguration.Builder)RequestPaymentConfiguration.builder().apply(requestPaymentConfiguration)).build());
        }

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

