/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.s3.model.Grantee;
import software.amazon.awssdk.services.s3.model.Permission;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Grant
implements ToCopyableBuilder<Builder, Grant> {
    private final Grantee grantee;
    private final String permission;

    private Grant(BuilderImpl builder) {
        this.grantee = builder.grantee;
        this.permission = builder.permission;
    }

    public Grantee grantee() {
        return this.grantee;
    }

    public Permission permission() {
        return Permission.fromValue(this.permission);
    }

    public String permissionAsString() {
        return this.permission;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.grantee());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Grant)) {
            return false;
        }
        Grant other = (Grant)obj;
        return Objects.equals(this.grantee(), other.grantee()) && Objects.equals(this.permissionAsString(), other.permissionAsString());
    }

    public String toString() {
        return ToString.builder((String)"Grant").add("Grantee", (Object)this.grantee()).add("Permission", (Object)this.permissionAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Grantee": {
                return Optional.of(clazz.cast(this.grantee()));
            }
            case "Permission": {
                return Optional.of(clazz.cast(this.permissionAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Grantee grantee;
        private String permission;

        private BuilderImpl() {
        }

        private BuilderImpl(Grant model) {
            this.grantee(model.grantee);
            this.permission(model.permission);
        }

        public final Grantee.Builder getGrantee() {
            return this.grantee != null ? this.grantee.toBuilder() : null;
        }

        @Override
        public final Builder grantee(Grantee grantee) {
            this.grantee = grantee;
            return this;
        }

        public final void setGrantee(Grantee.BuilderImpl grantee) {
            this.grantee = grantee != null ? grantee.build() : null;
        }

        public final String getPermission() {
            return this.permission;
        }

        @Override
        public final Builder permission(String permission) {
            this.permission = permission;
            return this;
        }

        @Override
        public final Builder permission(Permission permission) {
            this.permission(permission.toString());
            return this;
        }

        public final void setPermission(String permission) {
            this.permission = permission;
        }

        public Grant build() {
            return new Grant(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Grant> {
        public Builder grantee(Grantee var1);

        default public Builder grantee(Consumer<Grantee.Builder> grantee) {
            return this.grantee((Grantee)((Grantee.Builder)Grantee.builder().apply(grantee)).build());
        }

        public Builder permission(String var1);

        public Builder permission(Permission var1);
    }
}

