/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.s3.model.Delete;
import software.amazon.awssdk.services.s3.model.RequestPayer;
import software.amazon.awssdk.services.s3.model.S3Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteObjectsRequest
extends S3Request
implements ToCopyableBuilder<Builder, DeleteObjectsRequest> {
    private final String bucket;
    private final Delete delete;
    private final String mfa;
    private final String requestPayer;

    private DeleteObjectsRequest(BuilderImpl builder) {
        super(builder);
        this.bucket = builder.bucket;
        this.delete = builder.delete;
        this.mfa = builder.mfa;
        this.requestPayer = builder.requestPayer;
    }

    public String bucket() {
        return this.bucket;
    }

    public Delete delete() {
        return this.delete;
    }

    public String mfa() {
        return this.mfa;
    }

    public RequestPayer requestPayer() {
        return RequestPayer.fromValue(this.requestPayer);
    }

    public String requestPayerAsString() {
        return this.requestPayer;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.delete());
        hashCode = 31 * hashCode + Objects.hashCode(this.mfa());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestPayerAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteObjectsRequest)) {
            return false;
        }
        DeleteObjectsRequest other = (DeleteObjectsRequest)((Object)obj);
        return Objects.equals(this.bucket(), other.bucket()) && Objects.equals(this.delete(), other.delete()) && Objects.equals(this.mfa(), other.mfa()) && Objects.equals(this.requestPayerAsString(), other.requestPayerAsString());
    }

    public String toString() {
        return ToString.builder((String)"DeleteObjectsRequest").add("Bucket", (Object)this.bucket()).add("Delete", (Object)this.delete()).add("MFA", (Object)this.mfa()).add("RequestPayer", (Object)this.requestPayerAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Bucket": {
                return Optional.of(clazz.cast(this.bucket()));
            }
            case "Delete": {
                return Optional.of(clazz.cast(this.delete()));
            }
            case "MFA": {
                return Optional.of(clazz.cast(this.mfa()));
            }
            case "RequestPayer": {
                return Optional.of(clazz.cast(this.requestPayerAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends S3Request.BuilderImpl
    implements Builder {
        private String bucket;
        private Delete delete;
        private String mfa;
        private String requestPayer;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteObjectsRequest model) {
            super(model);
            this.bucket(model.bucket);
            this.delete(model.delete);
            this.mfa(model.mfa);
            this.requestPayer(model.requestPayer);
        }

        public final String getBucket() {
            return this.bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final Delete.Builder getDelete() {
            return this.delete != null ? this.delete.toBuilder() : null;
        }

        @Override
        public final Builder delete(Delete delete) {
            this.delete = delete;
            return this;
        }

        public final void setDelete(Delete.BuilderImpl delete) {
            this.delete = delete != null ? delete.build() : null;
        }

        public final String getMFA() {
            return this.mfa;
        }

        @Override
        public final Builder mfa(String mfa) {
            this.mfa = mfa;
            return this;
        }

        public final void setMFA(String mfa) {
            this.mfa = mfa;
        }

        public final String getRequestPayer() {
            return this.requestPayer;
        }

        @Override
        public final Builder requestPayer(String requestPayer) {
            this.requestPayer = requestPayer;
            return this;
        }

        @Override
        public final Builder requestPayer(RequestPayer requestPayer) {
            this.requestPayer(requestPayer.toString());
            return this;
        }

        public final void setRequestPayer(String requestPayer) {
            this.requestPayer = requestPayer;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeleteObjectsRequest build() {
            return new DeleteObjectsRequest(this);
        }
    }

    public static interface Builder
    extends S3Request.Builder,
    CopyableBuilder<Builder, DeleteObjectsRequest> {
        public Builder bucket(String var1);

        public Builder delete(Delete var1);

        default public Builder delete(Consumer<Delete.Builder> delete) {
            return this.delete((Delete)((Delete.Builder)Delete.builder().apply(delete)).build());
        }

        public Builder mfa(String var1);

        public Builder requestPayer(String var1);

        public Builder requestPayer(RequestPayer var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

