/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.PathMarshallers;
import software.amazon.awssdk.services.s3.model.GetBucketRequestPaymentRequest;
import software.amazon.awssdk.util.UriResourcePathUtils;

public class GetBucketRequestPaymentRequestMarshaller
implements Marshaller<Request<GetBucketRequestPaymentRequest>, GetBucketRequestPaymentRequest> {
    public Request<GetBucketRequestPaymentRequest> marshall(GetBucketRequestPaymentRequest getBucketRequestPaymentRequest) {
        if (getBucketRequestPaymentRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getBucketRequestPaymentRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/{Bucket}?requestPayment";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParamtersToRequest((Request)request, (String)uriResourcePath);
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", getBucketRequestPaymentRequest.bucket());
        request.setResourcePath(uriResourcePath);
        return request;
    }
}

