/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.AccessControlPolicy;
import software.amazon.awssdk.services.s3.model.Grant;
import software.amazon.awssdk.services.s3.transform.GrantUnmarshaller;
import software.amazon.awssdk.services.s3.transform.OwnerUnmarshaller;

public class AccessControlPolicyUnmarshaller
implements Unmarshaller<AccessControlPolicy, StaxUnmarshallerContext> {
    private static AccessControlPolicyUnmarshaller INSTANCE;

    public AccessControlPolicy unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        AccessControlPolicy.Builder accessControlPolicy = AccessControlPolicy.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("AccessControlList", targetDepth)) {
                    accessControlPolicy.grants(new ArrayList<Grant>());
                    continue;
                }
                if (context.testExpression("AccessControlList/Grant", targetDepth)) {
                    accessControlPolicy.grants(GrantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Owner", targetDepth)) continue;
                accessControlPolicy.owner(OwnerUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (AccessControlPolicy)accessControlPolicy.build();
    }

    public static AccessControlPolicyUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AccessControlPolicyUnmarshaller();
        }
        return INSTANCE;
    }
}

