/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.s3.model.Event;
import software.amazon.awssdk.services.s3.model.EventListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class QueueConfigurationDeprecated
implements ToCopyableBuilder<Builder, QueueConfigurationDeprecated> {
    private final String id;
    private final String event;
    private final List<String> events;
    private final String queue;

    private QueueConfigurationDeprecated(BuilderImpl builder) {
        this.id = builder.id;
        this.event = builder.event;
        this.events = builder.events;
        this.queue = builder.queue;
    }

    public String id() {
        return this.id;
    }

    public String event() {
        return this.event;
    }

    public List<String> events() {
        return this.events;
    }

    public String queue() {
        return this.queue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.event() == null ? 0 : this.event().hashCode());
        hashCode = 31 * hashCode + (this.events() == null ? 0 : this.events().hashCode());
        hashCode = 31 * hashCode + (this.queue() == null ? 0 : this.queue().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueueConfigurationDeprecated)) {
            return false;
        }
        QueueConfigurationDeprecated other = (QueueConfigurationDeprecated)obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.event() == null ^ this.event() == null) {
            return false;
        }
        if (other.event() != null && !other.event().equals(this.event())) {
            return false;
        }
        if (other.events() == null ^ this.events() == null) {
            return false;
        }
        if (other.events() != null && !other.events().equals(this.events())) {
            return false;
        }
        if (other.queue() == null ^ this.queue() == null) {
            return false;
        }
        return other.queue() == null || other.queue().equals(this.queue());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.event() != null) {
            sb.append("Event: ").append(this.event()).append(",");
        }
        if (this.events() != null) {
            sb.append("Events: ").append(this.events()).append(",");
        }
        if (this.queue() != null) {
            sb.append("Queue: ").append(this.queue()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String id;
        private String event;
        private List<String> events;
        private String queue;

        private BuilderImpl() {
        }

        private BuilderImpl(QueueConfigurationDeprecated model) {
            this.setId(model.id);
            this.setEvent(model.event);
            this.setEvents(model.events);
            this.setQueue(model.queue);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getEvent() {
            return this.event;
        }

        @Override
        public final Builder event(String event) {
            this.event = event;
            return this;
        }

        @Override
        public final Builder event(Event event) {
            this.event(event.toString());
            return this;
        }

        public final void setEvent(String event) {
            this.event = event;
        }

        public final void setEvent(Event event) {
            this.event(event.toString());
        }

        public final Collection<String> getEvents() {
            return this.events;
        }

        @Override
        public final Builder events(Collection<String> events) {
            this.events = EventListCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(String ... events) {
            if (this.events == null) {
                this.events = new ArrayList<String>(events.length);
            }
            for (String e : events) {
                this.events.add(e);
            }
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(Event ... events) {
            if (this.events == null) {
                this.events = new ArrayList<String>(events.length);
            }
            for (Event ele : events) {
                this.events.add(ele.toString());
            }
            return this;
        }

        public final void setEvents(Collection<String> events) {
            this.events = EventListCopier.copy(events);
        }

        @SafeVarargs
        public final void setEvents(String ... events) {
            if (this.events == null) {
                this.events = new ArrayList<String>(events.length);
            }
            for (String e : events) {
                this.events.add(e);
            }
        }

        @SafeVarargs
        public final void setEvents(Event ... events) {
            if (this.events == null) {
                this.events = new ArrayList<String>(events.length);
            }
            for (Event ele : events) {
                this.events.add(ele.toString());
            }
        }

        public final String getQueue() {
            return this.queue;
        }

        @Override
        public final Builder queue(String queue) {
            this.queue = queue;
            return this;
        }

        public final void setQueue(String queue) {
            this.queue = queue;
        }

        public QueueConfigurationDeprecated build() {
            return new QueueConfigurationDeprecated(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, QueueConfigurationDeprecated> {
        public Builder id(String var1);

        public Builder event(String var1);

        public Builder event(Event var1);

        public Builder events(Collection<String> var1);

        public Builder events(String ... var1);

        public Builder events(Event ... var1);

        public Builder queue(String var1);
    }
}

