/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.s3.model.CommonPrefix;
import software.amazon.awssdk.services.s3.model.CommonPrefixListCopier;
import software.amazon.awssdk.services.s3.model.EncodingType;
import software.amazon.awssdk.services.s3.model.MultipartUpload;
import software.amazon.awssdk.services.s3.model.MultipartUploadListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListMultipartUploadsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListMultipartUploadsResponse> {
    private final String bucket;
    private final String keyMarker;
    private final String uploadIdMarker;
    private final String nextKeyMarker;
    private final String prefix;
    private final String delimiter;
    private final String nextUploadIdMarker;
    private final Integer maxUploads;
    private final Boolean isTruncated;
    private final List<MultipartUpload> uploads;
    private final List<CommonPrefix> commonPrefixes;
    private final String encodingType;

    private ListMultipartUploadsResponse(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.keyMarker = builder.keyMarker;
        this.uploadIdMarker = builder.uploadIdMarker;
        this.nextKeyMarker = builder.nextKeyMarker;
        this.prefix = builder.prefix;
        this.delimiter = builder.delimiter;
        this.nextUploadIdMarker = builder.nextUploadIdMarker;
        this.maxUploads = builder.maxUploads;
        this.isTruncated = builder.isTruncated;
        this.uploads = builder.uploads;
        this.commonPrefixes = builder.commonPrefixes;
        this.encodingType = builder.encodingType;
    }

    public String bucket() {
        return this.bucket;
    }

    public String keyMarker() {
        return this.keyMarker;
    }

    public String uploadIdMarker() {
        return this.uploadIdMarker;
    }

    public String nextKeyMarker() {
        return this.nextKeyMarker;
    }

    public String prefix() {
        return this.prefix;
    }

    public String delimiter() {
        return this.delimiter;
    }

    public String nextUploadIdMarker() {
        return this.nextUploadIdMarker;
    }

    public Integer maxUploads() {
        return this.maxUploads;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public List<MultipartUpload> uploads() {
        return this.uploads;
    }

    public List<CommonPrefix> commonPrefixes() {
        return this.commonPrefixes;
    }

    public String encodingType() {
        return this.encodingType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.bucket() == null ? 0 : this.bucket().hashCode());
        hashCode = 31 * hashCode + (this.keyMarker() == null ? 0 : this.keyMarker().hashCode());
        hashCode = 31 * hashCode + (this.uploadIdMarker() == null ? 0 : this.uploadIdMarker().hashCode());
        hashCode = 31 * hashCode + (this.nextKeyMarker() == null ? 0 : this.nextKeyMarker().hashCode());
        hashCode = 31 * hashCode + (this.prefix() == null ? 0 : this.prefix().hashCode());
        hashCode = 31 * hashCode + (this.delimiter() == null ? 0 : this.delimiter().hashCode());
        hashCode = 31 * hashCode + (this.nextUploadIdMarker() == null ? 0 : this.nextUploadIdMarker().hashCode());
        hashCode = 31 * hashCode + (this.maxUploads() == null ? 0 : this.maxUploads().hashCode());
        hashCode = 31 * hashCode + (this.isTruncated() == null ? 0 : this.isTruncated().hashCode());
        hashCode = 31 * hashCode + (this.uploads() == null ? 0 : this.uploads().hashCode());
        hashCode = 31 * hashCode + (this.commonPrefixes() == null ? 0 : this.commonPrefixes().hashCode());
        hashCode = 31 * hashCode + (this.encodingType() == null ? 0 : this.encodingType().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMultipartUploadsResponse)) {
            return false;
        }
        ListMultipartUploadsResponse other = (ListMultipartUploadsResponse)((Object)obj);
        if (other.bucket() == null ^ this.bucket() == null) {
            return false;
        }
        if (other.bucket() != null && !other.bucket().equals(this.bucket())) {
            return false;
        }
        if (other.keyMarker() == null ^ this.keyMarker() == null) {
            return false;
        }
        if (other.keyMarker() != null && !other.keyMarker().equals(this.keyMarker())) {
            return false;
        }
        if (other.uploadIdMarker() == null ^ this.uploadIdMarker() == null) {
            return false;
        }
        if (other.uploadIdMarker() != null && !other.uploadIdMarker().equals(this.uploadIdMarker())) {
            return false;
        }
        if (other.nextKeyMarker() == null ^ this.nextKeyMarker() == null) {
            return false;
        }
        if (other.nextKeyMarker() != null && !other.nextKeyMarker().equals(this.nextKeyMarker())) {
            return false;
        }
        if (other.prefix() == null ^ this.prefix() == null) {
            return false;
        }
        if (other.prefix() != null && !other.prefix().equals(this.prefix())) {
            return false;
        }
        if (other.delimiter() == null ^ this.delimiter() == null) {
            return false;
        }
        if (other.delimiter() != null && !other.delimiter().equals(this.delimiter())) {
            return false;
        }
        if (other.nextUploadIdMarker() == null ^ this.nextUploadIdMarker() == null) {
            return false;
        }
        if (other.nextUploadIdMarker() != null && !other.nextUploadIdMarker().equals(this.nextUploadIdMarker())) {
            return false;
        }
        if (other.maxUploads() == null ^ this.maxUploads() == null) {
            return false;
        }
        if (other.maxUploads() != null && !other.maxUploads().equals(this.maxUploads())) {
            return false;
        }
        if (other.isTruncated() == null ^ this.isTruncated() == null) {
            return false;
        }
        if (other.isTruncated() != null && !other.isTruncated().equals(this.isTruncated())) {
            return false;
        }
        if (other.uploads() == null ^ this.uploads() == null) {
            return false;
        }
        if (other.uploads() != null && !other.uploads().equals(this.uploads())) {
            return false;
        }
        if (other.commonPrefixes() == null ^ this.commonPrefixes() == null) {
            return false;
        }
        if (other.commonPrefixes() != null && !other.commonPrefixes().equals(this.commonPrefixes())) {
            return false;
        }
        if (other.encodingType() == null ^ this.encodingType() == null) {
            return false;
        }
        return other.encodingType() == null || other.encodingType().equals(this.encodingType());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.bucket() != null) {
            sb.append("Bucket: ").append(this.bucket()).append(",");
        }
        if (this.keyMarker() != null) {
            sb.append("KeyMarker: ").append(this.keyMarker()).append(",");
        }
        if (this.uploadIdMarker() != null) {
            sb.append("UploadIdMarker: ").append(this.uploadIdMarker()).append(",");
        }
        if (this.nextKeyMarker() != null) {
            sb.append("NextKeyMarker: ").append(this.nextKeyMarker()).append(",");
        }
        if (this.prefix() != null) {
            sb.append("Prefix: ").append(this.prefix()).append(",");
        }
        if (this.delimiter() != null) {
            sb.append("Delimiter: ").append(this.delimiter()).append(",");
        }
        if (this.nextUploadIdMarker() != null) {
            sb.append("NextUploadIdMarker: ").append(this.nextUploadIdMarker()).append(",");
        }
        if (this.maxUploads() != null) {
            sb.append("MaxUploads: ").append(this.maxUploads()).append(",");
        }
        if (this.isTruncated() != null) {
            sb.append("IsTruncated: ").append(this.isTruncated()).append(",");
        }
        if (this.uploads() != null) {
            sb.append("Uploads: ").append(this.uploads()).append(",");
        }
        if (this.commonPrefixes() != null) {
            sb.append("CommonPrefixes: ").append(this.commonPrefixes()).append(",");
        }
        if (this.encodingType() != null) {
            sb.append("EncodingType: ").append(this.encodingType()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String bucket;
        private String keyMarker;
        private String uploadIdMarker;
        private String nextKeyMarker;
        private String prefix;
        private String delimiter;
        private String nextUploadIdMarker;
        private Integer maxUploads;
        private Boolean isTruncated;
        private List<MultipartUpload> uploads;
        private List<CommonPrefix> commonPrefixes;
        private String encodingType;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMultipartUploadsResponse model) {
            this.setBucket(model.bucket);
            this.setKeyMarker(model.keyMarker);
            this.setUploadIdMarker(model.uploadIdMarker);
            this.setNextKeyMarker(model.nextKeyMarker);
            this.setPrefix(model.prefix);
            this.setDelimiter(model.delimiter);
            this.setNextUploadIdMarker(model.nextUploadIdMarker);
            this.setMaxUploads(model.maxUploads);
            this.setIsTruncated(model.isTruncated);
            this.setUploads(model.uploads);
            this.setCommonPrefixes(model.commonPrefixes);
            this.setEncodingType(model.encodingType);
        }

        public final String getBucket() {
            return this.bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getKeyMarker() {
            return this.keyMarker;
        }

        @Override
        public final Builder keyMarker(String keyMarker) {
            this.keyMarker = keyMarker;
            return this;
        }

        public final void setKeyMarker(String keyMarker) {
            this.keyMarker = keyMarker;
        }

        public final String getUploadIdMarker() {
            return this.uploadIdMarker;
        }

        @Override
        public final Builder uploadIdMarker(String uploadIdMarker) {
            this.uploadIdMarker = uploadIdMarker;
            return this;
        }

        public final void setUploadIdMarker(String uploadIdMarker) {
            this.uploadIdMarker = uploadIdMarker;
        }

        public final String getNextKeyMarker() {
            return this.nextKeyMarker;
        }

        @Override
        public final Builder nextKeyMarker(String nextKeyMarker) {
            this.nextKeyMarker = nextKeyMarker;
            return this;
        }

        public final void setNextKeyMarker(String nextKeyMarker) {
            this.nextKeyMarker = nextKeyMarker;
        }

        public final String getPrefix() {
            return this.prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public final String getDelimiter() {
            return this.delimiter;
        }

        @Override
        public final Builder delimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public final void setDelimiter(String delimiter) {
            this.delimiter = delimiter;
        }

        public final String getNextUploadIdMarker() {
            return this.nextUploadIdMarker;
        }

        @Override
        public final Builder nextUploadIdMarker(String nextUploadIdMarker) {
            this.nextUploadIdMarker = nextUploadIdMarker;
            return this;
        }

        public final void setNextUploadIdMarker(String nextUploadIdMarker) {
            this.nextUploadIdMarker = nextUploadIdMarker;
        }

        public final Integer getMaxUploads() {
            return this.maxUploads;
        }

        @Override
        public final Builder maxUploads(Integer maxUploads) {
            this.maxUploads = maxUploads;
            return this;
        }

        public final void setMaxUploads(Integer maxUploads) {
            this.maxUploads = maxUploads;
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final Collection<MultipartUpload> getUploads() {
            return this.uploads;
        }

        @Override
        public final Builder uploads(Collection<MultipartUpload> uploads) {
            this.uploads = MultipartUploadListCopier.copy(uploads);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder uploads(MultipartUpload ... uploads) {
            if (this.uploads == null) {
                this.uploads = new ArrayList<MultipartUpload>(uploads.length);
            }
            for (MultipartUpload e : uploads) {
                this.uploads.add(e);
            }
            return this;
        }

        public final void setUploads(Collection<MultipartUpload> uploads) {
            this.uploads = MultipartUploadListCopier.copy(uploads);
        }

        @SafeVarargs
        public final void setUploads(MultipartUpload ... uploads) {
            if (this.uploads == null) {
                this.uploads = new ArrayList<MultipartUpload>(uploads.length);
            }
            for (MultipartUpload e : uploads) {
                this.uploads.add(e);
            }
        }

        public final Collection<CommonPrefix> getCommonPrefixes() {
            return this.commonPrefixes;
        }

        @Override
        public final Builder commonPrefixes(Collection<CommonPrefix> commonPrefixes) {
            this.commonPrefixes = CommonPrefixListCopier.copy(commonPrefixes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commonPrefixes(CommonPrefix ... commonPrefixes) {
            if (this.commonPrefixes == null) {
                this.commonPrefixes = new ArrayList<CommonPrefix>(commonPrefixes.length);
            }
            for (CommonPrefix e : commonPrefixes) {
                this.commonPrefixes.add(e);
            }
            return this;
        }

        public final void setCommonPrefixes(Collection<CommonPrefix> commonPrefixes) {
            this.commonPrefixes = CommonPrefixListCopier.copy(commonPrefixes);
        }

        @SafeVarargs
        public final void setCommonPrefixes(CommonPrefix ... commonPrefixes) {
            if (this.commonPrefixes == null) {
                this.commonPrefixes = new ArrayList<CommonPrefix>(commonPrefixes.length);
            }
            for (CommonPrefix e : commonPrefixes) {
                this.commonPrefixes.add(e);
            }
        }

        public final String getEncodingType() {
            return this.encodingType;
        }

        @Override
        public final Builder encodingType(String encodingType) {
            this.encodingType = encodingType;
            return this;
        }

        @Override
        public final Builder encodingType(EncodingType encodingType) {
            this.encodingType(encodingType.toString());
            return this;
        }

        public final void setEncodingType(String encodingType) {
            this.encodingType = encodingType;
        }

        public final void setEncodingType(EncodingType encodingType) {
            this.encodingType(encodingType.toString());
        }

        public ListMultipartUploadsResponse build() {
            return new ListMultipartUploadsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListMultipartUploadsResponse> {
        public Builder bucket(String var1);

        public Builder keyMarker(String var1);

        public Builder uploadIdMarker(String var1);

        public Builder nextKeyMarker(String var1);

        public Builder prefix(String var1);

        public Builder delimiter(String var1);

        public Builder nextUploadIdMarker(String var1);

        public Builder maxUploads(Integer var1);

        public Builder isTruncated(Boolean var1);

        public Builder uploads(Collection<MultipartUpload> var1);

        public Builder uploads(MultipartUpload ... var1);

        public Builder commonPrefixes(Collection<CommonPrefix> var1);

        public Builder commonPrefixes(CommonPrefix ... var1);

        public Builder encodingType(String var1);

        public Builder encodingType(EncodingType var1);
    }
}

